<?php

namespace XF\Data;

class WebAuthn
{
	public function getDataForAAGUID(string $AAGUID): ?array
	{
		return $this->getCombinedAAGUIDList()[$AAGUID] ?? null;
	}

	//###### GENERATED CODE START ######
	public function getCombinedAAGUIDList(): array
	{
		return [
			'fcb1bcb4f370078c6993bc24d0ae3fbe' => [
				'name' => 'Ledger Nano X FIDO2 Authenticator',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'6e8d1eae8d404c25bcf84633959afc71' => [
				'name' => 'Veridium iOS SDK',
				'icon_light' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAAEEfUpiAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAAeGVYSWZNTQAqAAAACAAFARIAAwAAAAEAAQAAARoABQAAAAEAAABKARsABQAAAAEAAABSASgAAwAAAAEAAgAAh2kABAAAAAEAAABaAAAAAAAAAEgAAAABAAAASAAAAAEAAqACAAQAAAABAAAAIKADAAQAAAABAAAAIAAAAAAQdIdCAAAACXBIWXMAAAsTAAALEwEAmpwYAAACZmlUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iWE1QIENvcmUgNi4wLjAiPgogICA8cmRmOlJERiB4bWxuczpyZGY9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkvMDIvMjItcmRmLXN5bnRheC1ucyMiPgogICAgICA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0iIgogICAgICAgICAgICB4bWxuczp0aWZmPSJodHRwOi8vbnMuYWRvYmUuY29tL3RpZmYvMS4wLyIKICAgICAgICAgICAgeG1sbnM6ZXhpZj0iaHR0cDovL25zLmFkb2JlLmNvbS9leGlmLzEuMC8iPgogICAgICAgICA8dGlmZjpPcmllbnRhdGlvbj4xPC90aWZmOk9yaWVudGF0aW9uPgogICAgICAgICA8dGlmZjpSZXNvbHV0aW9uVW5pdD4yPC90aWZmOlJlc29sdXRpb25Vbml0PgogICAgICAgICA8ZXhpZjpQaXhlbFlEaW1lbnNpb24+OTY8L2V4aWY6UGl4ZWxZRGltZW5zaW9uPgogICAgICAgICA8ZXhpZjpQaXhlbFhEaW1lbnNpb24+OTY8L2V4aWY6UGl4ZWxYRGltZW5zaW9uPgogICAgICAgICA8ZXhpZjpDb2xvclNwYWNlPjE8L2V4aWY6Q29sb3JTcGFjZT4KICAgICAgPC9yZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CrOtllEAAAbOSURBVFgJtRdrbJNV9N77fV+77gnbSFyc4Ojmg2iMDjFKosAYBHyBY2D8YWKMzhB+OF9s+2MxyjAiGv9NQwwxMXEPEgzvDYrAEjQboAMxtN0YQ53Qtd2ra/s9rufc9ivt1q6QwG3S7957nvecc885l5DZhn17m0aXH+kaIJz8ePWsvwmR5aAvHPEOBJuY1UZc779AkzhUvt2ixHdKd7XarCEapMsPd/JrlzRiTE0QymijfPXcKCecU09TbRw7iU/ionzHXg5qdLqcq6srYgBavqPjCDeMahNRJoTKVZ1dfLA3QLgB3A0DYFz1NG20IBJzrl5ZNtjj/xKBlLF+T+SiZAJNLrN+02pasaP9Cy5ZPgAdkkdlS48yNvlfxAgFCZU4YStPnOKVLS2KiRYYGQgjUAxQmK443KkTSWJXzvkeoBr/CwAMgVSSiXvreso452TonG8MgJdNIKFUdZepQrw80BPgkkTzkQoAnFHjRVdD7QGxNv/szR0cvBsx14nftMdMRJo+X+ZwykM5/odkW0GfUHg6Qsp1bauE++XN7deGFO8UUfU+HUKEVXUedwoChyMtMzjCpoqnbBocA2zC7yWUxO0PAYdBa8yX8/KYOjr+OMlWLpBfCDnhWK7Zm9sx9lQQEPeDEIZ/nGgQoG4R9ZTz+RzsTyVGAleD/455tRKua3Hc+IQSndlyJR4O3lc6VTiMQmQC3uSUTvX/5s+SFcZAYkmcwJxQkEfpPk/DhvXmljs2Yc41q8qGzo4OyzIFTjzRKxrLyiaexg1szoDPmkhsMsHvTQKHQ66wPFJJsnPP8FDwE3fDKx8nIt6VuX17+7q0rksrMeZu8NAflJKG22IgrpXDYVTs/JmD8R8EX8o3bZBWZAwAku22R59jStZxIxwErxMDiM+z2lYuQjQTfXn2Y3uIbhwXlxmcanqM+QqPPbPM6YyHZhKjVjP+O8a5pm5KgsUWjDDlJIsYzdOBeN4yl1Zc8dUhCH89Gzw+M5yBiIlI5Ma7K452YcYAu0SDacxftFlScoYxKQPxdGMbENKwZ3nLBMiQOMuqnCcxZDnk5PMQ4Tu5ljKHqJRJzFW/lpaG8/toVZeTG5oGgiEFSiw0eH4ii2gq3qQUduGQBlk3hPezqBbqG9UAIkIN6r6BX/1ZRNfQRTOIqWLF6/pmjBhQ4IIhIpUl4vOM3Zj0afMYOjT5QiGOuMIsEsnPLfSGcCNxyFfOXNdhYx4eIcVQKaHjrvo1RQRTWlsd4iYNJknkCWoFL8VUikPR8JTudjdtKBJ7bRtnEOM+K5ks+hMtCmUXjYLG48yWQ2TGn/TYjS2IlHnEzm1v3nsFyyoSYOrOTBh1xa3g3REc7CN6v61Ty785aCWTU62QsR82A/GOCEjJJHYfETa2oLgW8lCQhNUQ+OcliL7Ru6YAnhaFlrmsxSDUWfH1IW5Q/QdwsYWrEQM6AhGyWEVuPachx1lGot/9C4s2YzxIChmGurnUCMZyAicoOc6FLe3uzsVV2pQWR00zwQPEzPyPZaQc6sTvmMGgxu3khm5E80nqTIYcmTUYdq04eoxLqv6qKaI2wW/m3vSvaWJMXnY33Y5lwmDsEpxuUTQDcrwFqV0MNIIftlPQV4r0YBj8+1XdZ3jV0a79/rlzhVUqe3qSczAWNEc0fwXuL14Cvh2q2HUAmPF6IxLmcGLkm/n6QVvCILdhR8HwBNC/Ympk6vg4pHdeTZSsADTqwTkjgZeFpgQEwygfWaLYrR27hVDKT0P83BPtN4WJM8WS0E6y5YJIut8IeAvcjTWLU2lr0UPCKApnrK361GkSGBz9ydvftpTlkVJ9ylDjTW6m06KpoVgwa47C1bAP0u3rl+vXHCZoyYuLhMIzFQCDMkUiWkQPet3jkUnfSJEk01qmEK5PTYId0gdU1FriX4O6IzOLlUIt/s713totaGls4QUUWgsTVyggKgG4A37qxI1Q4EZ/MAfckg/9NgHhiIvtXaaBGFB6cmRoOwY4lV+DJ1WPuCHbtiET3lu3GFvVpCEzCYrhlD5+3TWuhia0QtnCsK6h6cDFSbjpFio8KRR0LAThNigsnyJi/JZsTF2FTGbMdXrkw78vjFl0Qy6Ep4mKjyoQnymg0IRYaPEB1isxaaH7o3V0Tr/3czOxYc43hcz2ZfNK/Ps8jTVZWSorhOLaiUxBAxQQ91MCA5Uq8AqkVKcyewcKNXU31DxdMpk3hDhCKAbebQzWWxfVtM8eHHNtrXkemRLZ8gZYVBfCOBetkVCM0YM2baIQ+hJLQYF3D8gRlsKXwm3IzIxqvi0XfNZRAg+k/fhIElQJaTczl1vD+B9cMA7gyqvuTQAAAABJRU5ErkJggg==',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'9eb7eabc9db549a1b6c3555a802093f4' => [
				'name' => 'YubiKey 5 Series with NFC KVZR57',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'4d41190c7beb4a848018adf265a6352d' => [
				'name' => 'Thales IDPrime FIDO Bio',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'2772ce93eb4b40908b73330f48477d73' => [
				'name' => 'Security Key NFC by Yubico - Enterprise Edition Preview',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'6dae43beaf9c417b8b9f1b611168ec60' => [
				'name' => 'Dapple Authenticator from Dapple Security Inc.',
				'icon_light' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAABuCAYAAADYkhZIAAAACXBIWXMAAAsSAAALEgHS3X78AAAgAElEQVR4nNS9eXhb5Znw/bNlSZZkLbYs77LlTd4dJ85mJyHOQjYSIAEClC6UFkqZKW3fdKEtbaEwTN8ZaKcb7ZSWFlr2hqUJELKRhMTO4iTeF3m3ZHmRJWuXLdnO94ekE5vQTt9O25nvvi5fcaRznvOc+37ufXHMlStX+F8GhshP3Z/43gk0/Zn///8K4v6nN7AA7va6fN9LUCv0f+0CDoerGZhKSlKfBE4QJozzb7S/vwvE/C/gAI3H7TuqVCmqF354rr6FOFEcxpIclCoFH/5uVW3lX7S4zxuwB2dCHyRqVW8Bb/K/jCD/0wTQOByulqQktR5g/ytHeO/deg6/Wy9csGV7Lb/87XcB6GzvZ9+DT9LR1gfAdx6/n3vu3Q3AiGWC114+jEqtoKwsn9Ly/GsIB2EuSUpS/xb4Lf8LiPE/SQAB+Z3t/Tz68M85W98CgFahpEiXTv2gCYDWntdRqhRUGm/B7fIKC5SW5/POsafpbO/n9t1fXfTdrtJq+mKdlJbnU1NbyZbttdcQxOFwnUhKUv+IMGf8j8D/lA7QOO3ujiStOv3IoQb2PfgkbpcXrUKJ3efB7vNQ7/NQazCyZmM1SpWC/a8cWYRggHs/fTMAv/7lG7hdXqoyDDRZBwE40HERgI62Pv7w8mEgTLAH79vLkrVlpGfqSEpS1wF1Pm/ArkiQfYUwV/xDIfYf/UDCyG/TaFXpAO1tfQJiP7d6s3CRVqGkIj2bW++4HoD3FoglvUYLwLabrwMQRFYU+bUGo3DNQuho6+NfvvNLdq77PPfd/Sj1xy8BoEiQaYHfhEKzfuCRv92r/tfwj+aAsNjRqjOjH9x113YkrV7sDifOgE+40O7z8FLHWb6x5KtYLRNcPNUqfLd3SQ2tcgeyhPiP5AwAs9P+kRuIfn743Xommq1MigLc87nd3Pmx7cgU8TLguz5v4J//URzxj+QAjdPubktKUuv3v3KEO3Z/lSOHGtCla9nxha14gtMc7WlddMOtt4dP/8H9J9DKE9AqlOg1Wp46eZDb7tgCwGsR8QJhzthRslTQHR8FmwrL2VRYDoQ5xmIe53sP/4JVS+/iZz94CbjKEW6Hp52wT/J3g3+UEtY4ba4ejU6dvP+VI+x78EkAVOoE3n7nJ+gLMnjy4V9RMaXh8aOvIxNLqDUY+eKz/0Riipq1yz/J5rRimkaGaLIOkqVP5XTj84xYJlhT/YlFD3p48x6eazx5DQfsKq0mSZ5Aw5AJk230IzepVSgpLTRw8z1buSVCfACP2/d/lSrFQ39jnAD/GA7QOByuFo1OnXz8QIOAfAC3y8sPHn6WgG+az33tTk64+5gnjKyZNAmJKWqOHGrAYh7ntxdOCjL+zo9tB+Cdl96/5mGPH339I8XPgY6LvNbcgN3n+Uj9AGGx90FTK//52Avc97HvMmadBECpUnw94J828Xfghr83ATTOCVdfUpJa/+4bp7jns48s+vKuZWtZLc/m37//W5QqBZ986DZmRfMo85PYevt6YLGIicLeO8Pi5/VXj/zJB2sVSkHURMEfCkJMTPjfD8FCosxfucLhY2d54Jbv8OwzbwAgk8cXBoOhTuDmv+TF/1L4exIgfPJT1En7XzlC70vNaBVKAKoyDOg1WjwzATQyOc/+8g2OHGqgpCyPcx0vc/e/3kXd9SvwuH0MNg4ICz5Qu4UfPPA5dOlaWs500Dls5oHaLR/58K3GJSgk8dd8bvd5hD1EQS6WYEhMAcCoS0culgBwqb+P7z38C+7Y/VUC3mkkEnE88Ibb5f2/fwsEwd+PABqXzdWblKTWnzh4lm/v+zFPnTyI3eehLr+Uz9dej9lp54/tF3n86OsA7HvwSTxu36JFzta3LEJU/aAJSXkSAD995jUARLGxfPf6WwXiRqF1bAhfcPojN2f3eWiyDgoc4g8F+WCgE4BkhZKW0WEgzEVysYSz9S2sWnYXvV1DAKjUCV8L+Kdf+u8gKAp/DwJoHA5Xi1qn1jYda2X4tXb2VtUIX/ZOjvH40de5pXIVH1u2VpDX6hgpx947u2ihsf5xzgyZ2Ld+J1qFkn7fJDtvqWN0xCbY/hmqRNJVGuHU6jVajLp0+ibHOdbTJqwV/T4KtQYjx3raBG6MQvcCBZ2bpCNDncRnV23g5oJlnHr8PQ7uPwGATB5/h8fluwRo/jvI+lv7ARqnzdWTtMDa+fDJzE5Mpn7QxF3L1qKKlwufr8stwXSuB27bJHy2adlSno97g0BEZkfN0gN/uKp8v/HOtQfxo6ycqkwDMrFEIEq3bZRag1EwWR+o3cLT9YfDIZCImBpw2ABoHTXTax9HK0+ApnpCgSC7P74FpVqxNOCbbpQp4pfzV8aV/pYcIFg7C5F/+5Lw6V+VXYBeoxVO2DPnjvPUyYPCzY2WPjZklSxa8EqWjJ7JMZ6uP4zd5xFs/77TPYuu27d+J19at4NagxGz086eipXsKg0HV/9pzRZWZRdQP2iiNsdIYXKacJ8/eFUZj3td6DXaRT5ENCyyNDOXuvxS7H4vJtsoX973FE984xcAyBTx+X7f9AX+Sk74WxFA45x0dUWdrH0PPoleo2VnyTLhgg0FZXyuZjOfW72Zu1esF14uCna/l1HP4kOUmZXCrRGkb6xZRklZHhfOtmEeHhOu0Wu0pCSoaBgyCafaNe3HqEtnU2E554b7aI3I9MeOvk7PZPjeqB6Iwom+jkX7+c9b7xV+/0XDEfa3nFv0vbIvxLNPvAyAXBFfMD5mf/6vQZzokUce+WvuWwgah8PVkqhVZwzW9/H1L/0A93QAoy6DQl0aPz3zHk/t+gSvNDUgiYvjeG87l0YGBLkbA4Tm5wiEghQtzWf1hqUAjHWOkqBTUrNmCX29Zv7tsQeRaRX88N9/x3unzwsPz0nU0Tw6zOWRAQKhIP5QkPYxCw1DJmbn5xiesn2k2RmFWoORfet3Eh8nZlV2IY2WfgCkcWJ2FC9FGhfH4JTtWsTFxlAWq8MyMUlBdR4JCfIiny+QLpGID15z8Z+B/y4BhJDy+fcu0fCr0+wqraZrwkq/fZzOCStFugwA+uzjNFmHmL8yj1Iaz1fqdjE9O0twbha738u63BK+9t3PINcq2LP1i9TvP4vF6WBt3TJ23VyHTBsOJd9396OCeJFLpPzTmq0kSOK5YO5Dq1Cyu3wFl0bCpqt7OkBofu4jN75v/U4ahsLipmHIRJfNykVzn3D9hNdN08ggiXIFZqddEG+1BiN3LVvH4JSNQl063/rNb9mwbCk6gw6JRLwcGOL/IUX63xFBAvIP7j/B2z8+xOnBLl5tbqDWYKTGYAyLGb+HzokRTLZR5GIJWrkSR8DH8Z42zgx0YYlYQebpKZKNKVj7x+hq7+emshXEXXDS23zVDzgXyRd026wEQkHMTjtfeus5nq4PO2uB4AyN5n60CiVGXfpHbrrWYARgwDHBvvU7Bc/Y7vMs4pRiXQbGlPDh2VBQRro6EQjrje8ff5P6QROto2bW5Baz4/YvMdgWFnPB6dAzQNVfisS/lgME5O9/5QiPff3nmCZH6RwfYXZ+DplYwuzcHFkaLW1jZuHkpCk17Cqr5mDHRdrHLcQAWRottYYi2ixD5GpT+fHTL9MzYGHU7SRBKsV0rpclWyuRSiVok9R0v9POHUtrUUikNFmHFm0qND/HmMfJp1fUsa24ijxtKhfMfddsvjxNj0IST2VGNp0TViwuB3qNNpyP8IcjqzUGI5M+D+eHe9lRvJR0pYYzg92E5ueQS6TsKq3G4pzEG5zB6p7i9bfe59P33IRULo31un3bJFLJj/5eBFiE/H0PPkkgFBRMxRX6fG6rXE12YjLTsyFBAUZl80LbPDQ/BzExYfZ22amT5tLVO0S/Y4Ixj5Mm6xADtgnGe8bZeGMtYkkc6W4p715o5KXLZ4CrsX+jLp3yND0m2yi7K1YyFfBx3tzHsHNy0eZTEtSszy+lZ3IUsSiOEfcUy7PyuGTpXySyxjwunAE/gVCQ6/JKePbCCeQSKXafh1XZBQw57Vy09FOSmsn24ipO93bSeKGDW+/YgkQq0bgm3Zp4ufS9vzUBNFOT7o4krTqz40QH//nYC+g1WvQaLRqZnJXZBahlcs4MdDF3ZZ6UBLUgZ6ME0iqUJCuUuKcD6DVaHt16G786dxyz006zdYjqrFy6J6zkalMIhIK4pwO0dPdBTAyrayuZT5bw5ktH2FJUiUwsQSWV0TJmpn3Mgsk2GjmZdppHBzk71HPNCzj8Xnrt45hso4hFIu5bvYl8bSq99nFGXA5qI6IzJUFNTmIyVRkGJv0eHqjdglwiock6xOCUDWlcHO7pAMuycjEk6jjZ30nA4UcdL6d8uZF4uXQ18BYwds0m/koCaKYc7tZErSpz/ytH+D8PPond70UaJ0Yjk3N2qBeTbRT3dIB++zgXzP00DJmQiyXcvbKOFfp8Llr6kYslJEhlOPxe8pJSaTT3C46TezpArcFIrcHIztJqGiOnEsJhiZo1SyhdUkBsTCxdl/ooTE7jCiwSMybbKEW6DEpTs7hg7uOL63awNreIhohH3Wwd5OPL1qGKl9Fo7mPc6yJTlUTbuEVAalFKBqlKNSf6OoT1zg/3cdTUInDItqIqZBIJaUoNJ/rambtyBbvPg8YeS+2OFUjkEhwOV41MFv+LP4fUv1QJa6bs7o7EJFXWkbdOs+/BJ7l9SQ12nwdRTCw3lS0XLjQ77fzrjjtZm1sMgEwipTI9B2NyOpsLK6jKNHDPyg0AXJdfwu6K5Yu85a4JKw6fd1FMP6pQH/zsE/g8fnZ/dhvFy/J5uv4wLzddm6o0O+34QzMATAV8iGLDr/nUyYP4Q0Em/R7kYin+UJD6QRPv97Uz6p4iTakJK+NgkIq0bGHdAx0X0cjk+ENB9q3fydc23EjDkImOMQtN1iGqs/JZn1eCXCwhXiym4/eNACQlqZcAd/85xP4lHKBx2lw9icnq1KZjrfz80d/hCwXxh2bCKcQYkIklgkKUiyUkyhMYdU+RkqBme3EVkz43c1fmSVNpODfUw9mhHpTxcm6tXMXw1CQOv5fZK/M8ULuFvKQUStOymPC66RwfQa/R8tDGmzDZRtmYW0qiS0TmagNFqwuJ7/LTMz5KIBREr9Hy8OY9HOy4xLq8Yt5svUBofo5m6xBnBruBsL7I16ZydrgXs8su+CBFKRlYXQ6mpv24pwNkaZLY33KOnaXLBO6UxomZuzKPyTZKeVo254d7cc8EuH/1ZrI0Wl64fIbUBDUpCWrGRmzEpSrIyk3D7wlsEEvF3/9rCaBxTrq7NDp1SsO7jdz2iYcYdtpZnpXP7Pw83uAMYx4nCdJ4HlizlaM9rahkcnISk0lJUGPzujnQcZExj5Nzw70Ydem0jVuwOO14pgO4pgNsLqygc2IEuVhKaH6WFy+dptHSL8jvNKWG3slRNDIFs/PznG3rwD7nZ3VtJTFp8Tz/u4Nh81ahDIs8iZS7V9QRLxbTNmZe9DJ2n4cRl4O8pFTK0/SoZXLMTjtTAZ+gb7QKJdWZebSPW1iaYeBTK9ZzY9lyZmZn6bOPs7GgHOe0j90VK2myDpGTpOPccC9fWLuVmdlZ+h3jaOIVtDX3cP3e6xBLxfH8Gd/gzxFA8HDffeMUJ//zfcwuB4FQkCUZOZzoaycQCqJVKJn0ummyDqKOl3PPyg2MeaZotg7RPm4BYHf5Spqtg3TbRrmlYqUgs4enJklWqDjW04rZZWdzYQXdNisJUhnFKRmszS1ixBVea3DKhsk2yoBjgpPHG9l980bKqgohJoYUl4RPVK/jucaTET1SxAVz3zWZsW9vuYXr8kp4s+0CaplciPsEQkFBthfpMpjwufDOTNNkHWLU7WRppoHC5DS8wWlKU7PoiSjwRnMfPZNjjHucrM0rwTUdoNk6xAcDXWzUlxCjFqMvyMDv9m8WS8X/+v9CgEWm5sv//gb+UJAB+wSh+blF0cbbq2rwBGcoTsnAPR0gNiaG9nHLomuarUOE5ueIAXK1KczMhgR7+7OrNtIxbuH+muv5wam3qc7KY2fpMl64dJrg3KwQu4mCXqMlLymV379+iNvu2ML6Dcv5zRvv8Iv33hWuOdbTJiD/25v3MDs/h93nIRAKkp2o42hPK2annb1LagjNzwl7Abh39UZU8XKCs2GfYsLr5oK5j9n5ec4Mmmg095Gm0vBqcwPX5Zcw5nFh93vpt49zxNTC97bupSxNzztdlwmO+am7pRaxVCzhT3DBRxHgGjt/R8lSRlwOdlesxOKyC5ZJGGJoGR3C7vdicdrpnBjh29ffwqHuZuGKqgwDofk53NMBDIk6NhWWMeZxQUwMQ1OTzMyGSFYouTwyyLBzklP94eTIrrJqbq5YSeuYmUAoSFWGgfI0Pcuycnmv5TJ9vWZ23VzH1h1reOH5t6nJKkAjUzC2IKg34JigKsOAzeemdcxM27iZ/7jpU5hso5zq7+SJHXdisoX1yIrsfNrHLHhmAvhnQ9Tll9I+biEQCuINTjPmcSKXSClP1TPmdbE+rxT3dACRSMQ3Nt7E6pxCLo8MMBXw80F/J0XqNPJzM0nM1uKe8qyQyqQ/+K8IoHHa3W2JWnXWwuqFznELaSoNa3OLONB+UWDXqgwDRl26sMkoqOLljHldJCuUrM8r5faqGqRxYlZlF3Ckp5X3upux+73EAHcuXcPlkUFO9HUI9//L9jvYbKwgXZXI6YEuYolhzONkhT6fPscEffZxJrwuSiUppCYnYqjIYVl1CScOniVTnYTJNsqmwnIGHBO4pwO0jg7zxXXbUcfLKUrJICVBzXumFpIUSmZmg9xWuZrQ/DwysYRbKlchE0vxTPvJSdQJ4nJPxUrsfi9jHift4xbkEimn+jsRi0RsKixHr9GikEj55bnjDDgmIjrFT01SHvp1eUhlUhVwEhj8UwTQeF2+JlWiUn/6nQvcf//jQJjl7X4vZqed3KQUJv0e7P5wGWGCNJ5lmbk0DJnYVVrN/JUrEaSXsNpgRCOT02Mb45JlgEx1EquyC7g8MoBCIuXeVZtoH7dwxNRCeZqeGoMRdXzY1AuEgvzq3HEOm1romRxDLBKxraiKN9rOM+F1kaFK5NGttyEWiXjwRz9j6441VFUX45hy8/K7xwjNz7G9uIr+CCIAdAkqVPEyNPFyXm1uwOK0o4qXszwrjybrEAmSeLYXV/Hj0+/yTudlBqdsAvJrDUbsfi8Prt1O14SVmJgYIKwvthiXYJ5yUJKawdDUJDeULGXM48QfCjLmcXKitZW9uzcjU8uYmnCmyBTxL34kAXyewI8SVPJNjh4bz373RdbnldA+ZuarG26i02bFkKijaXQIiUiE3e+l1mBEp1Bh93upSM9me3EV7/e2M+CYoNHcR2V6Dsd72xCL4qjKzOHVpgbcMwEGpmws1+dRlJLO3Pw8vZNjmJ122scs+ENB7D4PA44JIOw1xwBFKRmLRNqYx0lZqp4XL59GHS/nj++c4rY7trBmUzVt9V30Do9wwdwneNwP1G7BGfBRlZlLaG6ObE0yF8x9eKYDtI+ZcU0HSFIk0Dlu5dzwVe+51mDEHwrymZUbeKWpHmJiuC6vmM2FFRQmpzHuddJnH6dAl0pwbpb2MQuz8/NsLChnSUYO3pkAvZPjJErlLF9fSVycKEcUJ3p8IQGihVkGYMDj9vH1j/8rHpuXqYCPuJhYSlIzuGgZIFmhpDorj/FIjEav0VKWqscZ8PGHlnAu98Nx971LakhWKMlJTGbC56F5ZJCNheVCgl6rUKKVJ2CyjWLUpWNx2lmZXYAz4KfJOoheo8UfClKVkYPZaV+k2KNO141ly/nZmfeEMnarZYLdWx5ke17lImUchV2l1XTbrMJa0VyxUZeByWZd9A5ahZJAcIa9VTUoJFL+2H6RIl3YS37h0mnhe5lECiC80/+57gaSI85lo7mfI8PtnGh6LrrsbhZUY4seeeQRnA73s/EyackLz79N47EWthZVCqe5bcwsiKDzw71oZArW55fwVlsjpwe7aR4NWzhRvbAur4ThqXAArCQ1k+caT3G0pxWTbZQEiZQpvw+TzSpEFZPlSgp16SRI4xl1TxEvFpOTqBPCGoFQMKxIMw0CZwDMzs0JIWn3dADnqJPCPD2VK4rJL9Dz1hsnrskNaxVKxCIRophYQVFH956m1GD3exblD7TyBK7LLyFDlUggGGJNbjhoOH/lCssycxnzOAmEgqzOKeTWytWcH+7lwbXbuTTSjycY4PxwL9mJOt5pu0hZRQH5BXpcUx5JvEz66iICiGJjfyeKE4m+9bWf0No3wKn+TsHGjwFUMjm7SqtpH7dQnJJJaWoW/tmQgOiFUJtjpN8+TlmanpnZENI4MTExMYITFIgURwVCQT5ZfR0xMbAhvwxlvIyhqUkUknjBCloIH69eK4SwVTI5a3OL6RgfQSyKY2mmIXwyXRLUxcksWVGMaWSEyxe7Fq1xe1UNa3OLeeHSaVZlF/DQxpuw+dyUpGbSMGTi0W17BaICfPG67Rh1GWSoEjk92MVzjacYcExgso3ysWVrSVOqsbgc3Fi2HK08gXV5JXww0El8nIRRt5POiRFSlRp2lS3j7EgfW7bXIoqNLRDFiR5bSIAqUZzoAY/bx/e+/QuqMgyo4mXY/V70Gi3u6UD4Zyb8b5pSzcHOywxP2T4y22RI0lGVaeDSyABXgAfXbceQqEOv0dI+buGhjTdTnpbFJcsAdyytpWV0mNbRYU71dzLmcS4yIRdCv32cWypWsa14Ce90Xhb8A7lEil6j5YKln9O9nRw/fZE9t2xi87bVFHnVvN14Ab1Gy8eXreNQdzPjHidmp53p2RCj7inmr8wzMDWJJl6OUhpPw1CPoLjbx8yo4xU813iS3KQUEqTx5GvTSJIncKi7GUfAx67Sap45e4zZ+Xlm5kK83XGJ/OQ0SlIyOdTdTFVmDnKxlHeaLnLPfbsRxYlELIiSih555JHVwB0tl000H2ulfdzC7ooVxMaKaB0dFpDsng5w76pN6BJUDE9NLnJeoiAXS1ifX0qGKpFGSz8xwMtN9TQMmQSv2DszzUXLAPnJqTxz7jgTXhfbiqv4oL9LWEMlkxMDpKk0uKcD/MdNn8Lu9/JqcwMpCWoeXLedgx3h2v6oiIrmJOZ9swxYRtmyvZakkhRefukQPn8ASVwcugQV24qrONbTJpx0q3sKz3SALcYl1OWXEggFuXf1JgKhGZZkGHjx8ml2llRTkpqJ0x8gWZGAXCJFq0jg48vWkihX0D05RqYqkecbTxGan6MsLYupgI/OiRGW6/PJVCchnYtl2XWVyNQygHHCTYSIHnnkkTuAOrFvnlRzDB3jFiwuB/328WtO+HX5Jeg1ycTHSZiZC11DhM3GCtYYiqgf6sYfnOGhjTfRbB0SYv95SanMzM3SNTGC2WlHr9Hy7etv4fnGU8zOzSEWiQQzNDQ/h1gURyAU5FB3syD/3TMB2scs13CKUZcOMTFUZeTw9qkGlpUaKVlWQEFhNq/vP8bglA33TAC5WCIchoX3dkTSpo3mPgqT0xmemkQjU9A+bsHqmWKNwcjvL31Ak3VISP5r5UqmAj6sbgeDUzZur6rlurwS4sUSpkMhxrwuVukLaBkdZnBqksqyAtIL05iadOlk8vinowSoA+p6+s185d+fZk/FSvK1qdQPXa2PiTo1CokUuUTCueEeCrRpgpJ7oHYLaUoNuUkpqGUKylKzON7bxgVzH+MeJ59cfh2rcwr5Q8s5CpJTBRkrFsWxJCObiyODxMTEoJLKEMfFkaxQUp6mF8zAhYSenZvDPxsmklGXLnxn93sFbgA4duICdRtXsKq2Eotlgo62PgKh4Ecif9/6nbza3MCYx4lKJic2JiYczyksJxCaYdBh4/3edkLzc+GEUoIK78w0h00tfHpFHR3jFrLUWg51N+OaDuCbmUYVLyNfm0ZRSgaqeDnxYjEDThvrtq0gVhSrjouYowIBhoZGef53B3EGfFRn5SGNE5Op1nJ7VQ3vdjcTCAVRx8vZUlTJFWJ4tblBeImo7L5sHeRUfyedEyP0TI5h93sJzc+RqU5CHS/n7FAP/lCQ7cVVKKRSDIk6VmcX8kFE/udpw1HKaCDN7vcy7nGSptIwOzcnWCzJCiV5SanXxHEWwsxMEP+wm/XbV7J58yraz3UxaFkcV/rPW+/lteYGZufn0Wu0giiLEnHUPcVmYyVJcgV99nEg7HwlSKWs1Bcgl0gYc7soSE7jgrmPGODL1+0gTaVBr9Fysq+D5fp8ZufnGHDYSBBJWbdnNXFxojgieuCa0sTVOYXkJCbTNmamNDWL7MRkAsFwcqPJOojZ6UATKSnct35nODoZsVq08gQCoSBK6dWqZKMuneM9bcTHSajKMLCpsFxIwLSODnOsp1VIa076PALnhauUpZiddqoiNr8/WkHhtP/JFqQoyMUSfFYXv/rRa3zhm5/ga0/cx8Bdj6KJiRfs/c/94RkgnHCJVkssBLPTzlFTC5nqJOGzTYXliGJjyU1KIVOdyONH30CrUPLVul14Z2b43cVT5CTqCMyGcE77sbqnGJqy8UbbeZa78vB4fCiVCgj7Xk0CB4yYx/nDK0fonRwjODdLw6CJE30dvNvVtEgXXLL0c9HST2h+joYhE9I4MXGxseyuWClUQESRsza3iPtrrmd2fp7K9Gzqh0xcsPRzvKeVltFhFBIpFpdD8IIDoSCB4IzANXsqV3Kir0Ow9aOg12gpT9Nj1KWTrtII90I4PnXvqo2YJke5PDJIw7kWyioKWFVbSWa6jvb6Lm4oXUZKgkoQW9E17T4Pt1SuwhVJzADcWFbNBwPd1BqMDDgmMCQlMzc/T7N1iEPdzbinA5Sn6VmVXUBwbhaH30e6KpFMVSJqmZyfnnkPpTQes9PONzftJrMyK1rj1A2ciL36UsnIxRL8oSDTkXDx3khdZzPWmdIAACAASURBVK3BiFwsIUudxMrsAvZW1fKtTeEGaa0igezEZH5y+hBVGQY2F1bw7ev3ADA0NcnpgW4OdFzEF5xBJpZg93nI0mhZnpVHRXq2QKxo2V807TfinmJ/yzkgzGkfhvpBE8d62qgfNC0qGTS77Dz7oRalfQ8+yYhlgutvWkvGagPvdTfj8HsFzo6uJxNLiIlZ3OB3rKeNLcYK9i6piQTc4jnR18Ef2xupyTHy1I2f4PaqGvrtE0z6PEjFYs4P95KhSmJ1duGietO3Oy/hGA6vPW6d3AYLcsLzV+aFh8rFUuRiCXnaFHaVVpOl1iKTSJFLpPROjnGgvZHnL55atEmAzokRBqZshObmWJtbjN3nwRnwsm/9ToJzs0KVnN3vpWPcwrnhXgCB0Hq1llqDkfYxC3afR6jT/3n94i6ZDQVlQPi0f7j62u7zkLOg3PzuFespT8zgq/f/GwDffex+4lLDyZiyND13r6i7WqIeE4N3ZgajLp3l+qsHJEmegC84w8Ob96CKlwniqsk6SOvoMF858HueOnmQ0Nws1xdWoJEpaLIOsr/13CJixsWKaGgJR31j40QJsEAJd/YO8tZrxxGLRLSPW9havISyND3dNit/bL9IIGKN7CqrxhcK8tW6XVy2DuHwewV2LU7JYH1eCYXJ6Yy47LSNWfCFgqzU5/PshRM0WQcjyL6CNziDVp6A3e8VLJNoFLEwOY2hBY5e1PqI5nCbI/nnaCjgw7DwpZusQ+H/++eYsE+xaetqli0vYfDsAC3mQQqSU+m2WbH7PMzOzTHmdWFx2klJUJMgDdcBDU9N8nbnJcrS9ORpU3mvu4UEaTx2v5dtRVW0jg0L+7gCTHhdvN56XlDmcrGEnCQdxSkZNFh6uPWOLSgUshTg0UVKeFVOIS3WIfyhIM3WIRqGepCLJUIHul6jpX3MwhfWbKXRMoAxOQ2dQoU/1Ma3N+/h6frDjHtcyMQS/tge7lQfcdp5LNIFIxdLqMzIwahL5/GjrwvBq4VjCew+D6p42TVBsdykFGIIe6d/rtg2CpsKy2kYNAnXmp12fvHz16heXcb122q4+bNbufKzWV66XL/oPn8oKNSB6jUGthdXUahLJzQ3x28aT2JMTqMjkmveWrwEUWyMIAIbzf10jFmEdlqtXEl2YjK+4DR7l9TwWvNZ9IXJi54ncEBwapoUc9j0iiq9aKJ6zOPEqEvnoY038V53M4e6m6lMz2bQYePMQBezc3NADPNX5pm7Ms+7XU3EAN/deivNo1dPx13Va8nXpvKH5rMkSOMhJoZdpctosg6xUl9Af+TEfLjkMFmhxBecZsLnFszRhXBjWTgX4Vhgkqrj5Zhd11pKvZf62HbjWlasqcDUOcTF1i6qMgyLHDuz0055mp4JrwtnIMA7nZfDJmpwhgxVEt22UULzc1Sm5zA3P48qXsa4x8lXNuzixtJqqjJzAUiQhsMkDUMmUhJUOKf9rE40UHGzUDr6nECAK+4Qv/rNm8zOzzPhdRGan+P7N3yMDHUSzdZwyrE5ws6BSLIhS6MlRammNDWLAx0XGXE5mJ2fY2lVEYnJajLj1LSPW/BERJQ/FMQZ8AspxkBwhunZWW4oXcb6/FJiiMFkG0Wv0bK5sIIJn1s4BNEDkatNucb2NzvtlKRmEicS4fCHZ0bY/R7c0wHBiYzCpMvN6dNN3PWpG1hWW84f33gf08gIe5fUCKKw1mCk2zbKoMOGe9qPTCJlzOMkhrCIidaQto9buGDuY0/FStTxcpqtQ2SoE4mLjeWVpgYsLgen+jtxTwcYcTmY8LrYWrSEghtKo9t5S1DCAw4bBzouLkoNysUShiO18cv1eYvaPs1OO9VZeWwsKBMGYwDsqVjFD375ED/51bdIV2lIV6oB2FJUick2Sq42hY8tXSNUI4tiYhGLRLzcVM+xSKd8VAFr5QnXnOCFRWBR8IeCnOjrICHSFRn2V8Knv+sj2pU62vr45Y9eRaGU8cxzjwAIVd3l6dmszC7ghpKlVKTrqdbnc0dVLRAuMjPZRtlcWCGsVZ6eTXZiMp6ZALMR89TstHP38vXCNXX5pazQ57Mur1hoSoyCQIDZuVnhwxqDkS1FlXRNWKlIz6Yqw8Cq7ELsPi9ysUToPvn+8Td59PAfFi1ozMpEliRn3hXkdH8XHWMW9q3fSbQh/43W8/iDM9wYQWSTdZB/f/8A7/e2C/LaHwrSOzkm1HpGLR2tQskRU6vw+4edp4UdL1G4vrD8mgY9gNY3m2hp7KKkLI/vPH4/ALlJ4VbV/S3nGHU7ydYk0zFu4Y/t4Uq3nSXLeGLHHUI5/CeXX8cX1mzFFfCTptRQazBSnZXH0Z42UiMHTxtJZBl16awxFPPZVRvpbO+/lgDRi8MvMkS/fQJdggpXwI/d7+FnZ97jQMdFsjRainQZpCk1fPv6PazLLWG5PvyAO6pqsYjD4qHhTDNHe8Pmqck2isPv5WsbbqQ4JZOTfR1YXY5F9v0DtVvQa7T86447yVxgRi7kLrvPg8lmBSBeLMHmdV+D2A+/S31EEUcT59EirgMdF/n4x76Fx+3jnnt3s2V7Le1jFvojYe4jphbe7ryM3ecJe+MZBhx+L8+ePyEQ1DszTfuYhe+89yo2nxv3tJ8MVSJysYSfnD4kKGetQsn3j7+F3ecmXixdOFxEIxBAI1ewu3wFEHZ8SlIyOWIKm1tmp53l+jzq8ksx2UY50HGRFy6d5rEjr6ORydlTsQqTbZSZ2RBLVoYb7VyWKaoycthWXMWBjotMeF1kqZNIViTQax9n3OtahLADHRex+zw0W4e4pWIlEPZOl+vzhRfZu6QGfyQIN+K0C8nxD0O4ESQsvqJ2e9QclUmkAgLdLi/3fuoRAH74k68yKQogk0jRyOTXcE2TdZADHReZmQ3x+Uhz+Out5/nx6XeRiyWYbKN0Rg7HdChIZUa20Av3zUgn5/ePv8Wj7726cNkqwQydCYV48dJpIFzEGgjOCMWrAOvzSinUpdNnH2eLsZLl+ny8wWlO9nVwyTLA2twiKtKzSc9LDSMvRkWTdYhvbLw5XO0QnGF6NkR5Wjb31ygoTsngaE8rWoWSqowcGgZN7K2qEfK48ojXvNDkjAYADUnhlOWfGrrhDwWF76IdMwXaVALBGew+D1WF5Ziddoy6dBS2eX75o1e574t7ef6Ff+G27V8mJUGNUZfB/pZzgpiL4sEfCvLz+sNCwbB9gUddm2MU4ktqmYK1hmL2LlnNwY5LaBVKZGIJRboMMhbElgQCRGPcEAmqiSVC8GtXaTVN1kGaRoaw+zwcNrVQqMtg1O0QEiMAzoCfW7PvAGD/8Q+oyy+lY8zCyuwC5ubnebPtAvWD3WSqk4iNiRGQVJCchndmmrYxC6kJasxOO7srVqJTqPjdpQ+uQfDh7hYhgPfnRtNUZRjwh2aE9qhNhRUc6LgoPDdKxMCLQZasKGZVbSVff+jTPPK9Xwi4yFJrOTNkIlOjZSRyMCDc6FGXX0pcrIiLln6arIO8t6Byo9Hcx0p9PoZIsbFenUxofhaz0440Tixcd015ulahxOK0hxMOETka3fSx3lb8kUzSQ2+/wKDDJjTM6TVajFlZqHSq8MTDWBGbCyuYmQvRMW7B4fdytCd8f7T3F6Aq3YDT72Mq4KPR3IckLnwmXrh0mn7H+J9Ertlpp37QtKjL/cO9YU3WQQHZZqdd0CdRCykagqgfNHHv3Y/icfvYe98NrKy5auW82tzAPcvXU6hNRS6WhMPkPg+nB7qwuOyc6GvnQMdFzE47hiTdotDI0/WH+fX592k09zPpvxqvGrBffa9FnvCmwnJ2lVYvKudYGCT78LUbCsqIjYnF7LRTV1DKitVhM3Vi0IY+USukCX9y+pBw38KTa7KNYonI5ehzor2+WrmSK1egQJsqfLc8K4/puVmWZ+VyoOMSgeAMeo32mr3+JVCtz6MzEoWFsD74zXdf4sEffpaf/PpbrFn+SdwuL/+0ZgtXYJF5Hu2q/+2Fk0BYQpSkZhIIBSlNyeK8uZf6iEjdVFDO40dfZ9zjZCrgE5R8BJqu4YC3Oy8L1cr+0AxysQS5WMLnazbzmZUb2Ld+J1nqJFbo8/nthZPMX5mPXCfFrQwH9E6ea+KFS6f5zYX3OdTVRFWGgR/d9CnkYgkfW7aWPRWrIrLfACye45Ch0uAPBmmyDhITA1b3FBAud9lRspS4mFjhxWUS6SIRFA1rQDif8FGmqkCArDyyFnDPrtJqfvHaWzz7zBsoVQqeiYzKnAr46ViQRZOLJcSJROwsvdqEHs5+pTLichCcmyVLHV73smWAk/2dEettFJU0Hn8oiEot+DfORRxg93mpzAh3hgSCM1yRKViTW0xhcho/bzi66AUOdTXTZB3k1WYJgVCQK1wBXbhAaW48QF1+Kd22UfyhIPnJqbhnprkuv5TOcQtvO2wEgjOYXXZuLl/JzFxI4Aqr20mRLh2zK8hRU6twQsc9Tl5uqhc85WgV3eL9e1Dr8wGE9teP0hH71u/k5/WHBYuoKtNAt81KVaaB7z38C67fsIpVtZV86aufYP8z7whiLZozyFInCevLxRLeaD2PyTa6qFVqV2k1Bzou0jM5hlwsEcY0yMUSSsryhOsWcYDZZWeNoYidpdVCkqM2xyiYiNGfIl06ZWlZ/Mv2O5iMIMGQqGNZVbgtSe2NJTg7S//kmDA4yeqewj3t58xAN66AD38oyM1ly5mLVE2LYkVUZRjYVrREkLM1C05vIBQkJUEFhMXhwlj+Qrl7MiIq/AuMioWwq7RamFGhlScIlp7JNioQ6847HsLj9vGlr3ycjXUrCISC3FK5ioc376HGYGR/yzkOdYUrzZ/YcSff3LQbhUQqECocJk8Q9iWTSKnJCedU7l0wGXIRAcImUjhKeTCirNbkFpMWyThF4aGNN7E0M5eUBDWq+HDBltlp56dnDpGam8JIxwivNjVwoOMiy7Jy+ec1W5n0eoiNiWHvkhrqCsp4ePMejLp0NDIFp4dMHDG10DFuoTIjG71GS742bMpGx8lEETrmcbEut4QiXfqiPS106P6rSOmxnlYq0sNcvtCMrTUYBYRZzONCZfjXn7qftikr3bZR3u68xITXhShWxBM77gSgbcyMMl5GpjqJfet3hmdklC6jKsPA0gUi9tXmBvQaLa+3nlu4nUFBBIliY69hV/e0n4cPvbKI1RvN/Qw6JtAqlCil8cTHiSlITuM7d4eH582O+6krKKN1dBj3dID5+XnOWXpZlmngS2+F6yMDoSC3V9XwVlsj24yV5Cen8c13XqJh0MT0bGjRHqLhhXCpRxBRbAwXhwcXIe6bHxpZo1Uoqckp5GDHJQqT09hTsYr/+/5b7Cqtpn7IxNLMXKzuqWuItVDhH363nt/9+o984jM38uYfnmLj9Z+jLZIgAqiP9J290XZB8J+uyyuhLE0vtOZWZRjCvo5cidlpp2lkkPtvu2kRAQQO8M5MC5mpKMzOz/PtzXuuxrcVSuoHu+m1j1OZnsP3juzn7HAPyzJzcSnDIeLuvmF6bKPEx4mZng3x28aTyMUS0lWJQjBPr9GSIIlnHhicstE+ZsaoS2d6NiRYNR8erKcQS7C4HIhiYxeJpqgFtDBABpAU8YSvyyvB7AqXUEZF6fONJ4URBd+OcGPTyCApCepFa7z6kwN4RlzkVRq4577dAsEBfnjjJ3lixx2Cs+gPBXnq5EFORXLYJtsoT50M969pZHK0CiVbi6pYlpW76BmLdECUcnKxhEe23iYUK8nixOg1WmpyClmZXQDAM+eOoVUoOdbTxqvNDaiywuNyEr1x1OWXcb2xMhxIkyu5YO7jeE87cnFYScfFxjLp99A2OozZaSc0N0eGKlGw7Y26dB7evIf/uOlTwt6i4uJYTxtLM3P5at2NAII4U0plwrVhJIdTphctAzgDfj65/Do+DPFxYp5uOILFaSc/OY2dpcvYW1UjpDq18gR+8vXwVMfvPHY/peX5NI0MYtSlM+F1kyCRoddoeWLHnUI4IlrHJItYdlqFEm9whkBwhjfaztMcEw6NT45PdcGChMy0w89Pn3kNrUJJSoKanslReifHuGDuwz0TwOy080DtFnomxxhwTPDEjjtpGDIJyZbPf/lOEpPVPPP4i3zQ38nSzLAXKomL4+xQD10TIwRCQfKSUjnQcfFqBszvpSxNT06ijrK0LKEWyBypzstPTmU2oqijYEhMoW3cjNkZbnE12UaxeqY+Mj055nEyPRvCMx1uMYrWu0J4auOJvg5SVBqmQ0E+GOjCZBulJseIw++lPF3PW5fPI3HPU72xkrpNK3jpxUMkiKT0OyY43tvGLRWriIsVsaVoCaMeJxNel5C+hXBJp9U9xYrsfDYUlLNh60oyizLwuH39CUr5rwQOiKYHAWJjYoQTVZVhoNZg5Ikdd/J252WaRgZZrs/n3a6mRbohr0jPgMlMcUomxSmZfP/4W/zszGGCs7PC/XuX1GD3h58TPd2bCyvwBqd5uv4wFy39fGbVRvyhII3mvsgQJe8ikQPw4uXTdE2M8EDtlnA1Q6Q+P3rivnzdDRQsnIwVClKVmcN/3PQp7l21URjGZ3E5MOrSWZZhIFmhEqyvFy+fpndyjOcbT2H3eei/0MeFw5fJzErhqR9/BZNtlNYI9yYrlIx5nDxz9ih1+aXXFAlE9yQXS3m78xIxunDOIjUj+V34kCe8b/1OvvnOS4LjEM2N+kMSvvnOS3xj080Up2Qs8mwBwfycHQ+gkEipHzKxu2IFZal6WiIb/Xn9YfyhIF/fcCNzV67wzXde4t923iVkut7pvIwhMUXInj24bjtaeQLtYxZebbpahRe1r+0+j8BFerUWaVxc2H9w2imOjJn54am3heuP9LRhso2SmqARiPJGa3jwU/Rd4Wo2LKojVujzuWDuZ/jx53k4U83122rY98WP89SPfo9eo8XqnuLccC89k2M4Lp9hXW4RSzIMPHv+fUE/7YpYRUd7WikuFXRAE3xIB3zYmjA77eGZOhF2ahoZ5HyklGRtbhGbCyvCumF5WAGebWzj1+feJ0OlwTsTrgO6oWQpuyJ+xeaCcs4OmlBKZWgVSi5ZBkiUJQhRzvrBboJzs8jFEt7pvMxUwCeMHNBrtOxdUkPXxIhgb0ctpCbrIDlJOqEo7HN/eIYfnnobuJpPGInolzfazn9kyCJKzIV1Rnafh9ykcFvtme6O8GQY7zRf+OYnKC3Px6hLj0wJCO9jW9ESthcvZX/r+UWVGacHunnsyH62LK9e+DcMmmCBDohWxi0E93Q4zVaWmkX7uIXeyTFGXA7kYgm7ypZTYygKWyXbl5NXlsOvn97PyaYWbq1cTf1gN42Wfq7LK8Hu80Z6tAykqRJ5r7uJltFh2sbM3FK5kor0bIy6dMQiEc6An9n5OXonx2ixDpGm0jDgmGB2bo65K/NsNlbSMzlGTEwMD9RuwTQ5KtStjnlc3Ld6M0ppvJDgXwh6jVaouI6WuZSl6VmhzxfapKJ9EbNzc/hDQRqGTILOsE1M4XP5qbt+JXWbVvBvT7/Aie6r43es7imarIN0jo8A8NSNYdN875IargCawmQ23VDDzExwJi5O9BX4M2Mro2UVSzJyhJTcrtJqagxGRt1TKKXxPNd4grWGYvKKwn93Z9IUjvJ126x8bcONTPl9fPmt55BJpOFYvN/Dw5v3cKKvXXjOz+uPMHdlDqvbid3nwahLxxEZY++PKO2azUb+2N5ITqKOQYcNq8sh5GcXnmC5WEKGKpFMdaKQa8hUJTLinhIyW1nqJPZUrmKrsZJXmxtoGDQJ1RN2vxejLp0V+nw0MjlHTK1sKCjjD81nBSlw9M3T3H7DRkrWl/DUj78iJHTg6pRFCIuyo6ZWfDPTdNusnBns5p/uvAsA55SnMTUtbGYvIsDCOZpRdo6yl16jJU4k4pvvvCTEYirS9CTK5GQWhEVCQkkyDJpoGDSh1ySTkqAiSZ7A0sxclmXlMjRlExIWUWiyDrKjZCmiGJGgexbC623n+XrdjWRptFRl5vDshZN8+bobeKW5YVG6ct/6nTx18iATXpcg0gLBGTYWhItpo+EHi8tBoK+DrcZKVFKZYMNHRyAvycjh8aOv4w8FkYslzMyGWJqZi1gkwuKyszQzD+sBE6IUGddvq+HuT92I0abgYMSy21Vazc7SZfz0zCEBl2ci/9bULgEgNU0rJNIFHaBLUAm2KyDkThdCuP4nTJzaHCPZicmkqRKxng3X8Xz38c9TWp6PPxTktxdOkKFKZFVOIVWZOZwf7qVnQZL9gdot7ChZyqbCcm4qW44/FC4J/OyqjYueafd5+NrbL5CSoOJYTxsjTjvxEgnVmYsdmigxnjp5kM/XbkGrUOKPlLF8eNxBNPVZnn71L2Y1WQc5PdAlID8QnIlk5qRM+jxhU9O4hPd72/jM757mnR8fIhQI8q1H76N1dlxwHi9ZB3nyxAFaRxcPCsnSpy4Mwp2I/iLogJiYGL7++M+AcCg3WaHktiWrBSqKRXECNxQkpxEbE8PxnjYaLf2823CO1WuWkJufyV2fugGVJoHLF7vw+gOcHe7lUFczKQkqJrxudpYs4+xwD2KRiLlId3oMMXRPWNlWXEVsTAxpSg13VNWiipdfbSeVSPHOTJOiDLdIRX0TAal+rzAtK0+bKnTvt4+ZFzVs1+WXkqpU82bbhUXNgA9v3sNFywAm2ygP1G5BHSnBv2Dpxz3tD0uD0SGhgOtsZxdpMjVV68rILMrg9y+/S6YikU+vqMPh9y6qRQLYsmMNW7bXEpwJzYjiRP8c/TyWiDbWpKhZHfnbXCbbKKlKDU+eOHh1JrP6amhgi7FSqDYA6Om3sKXuc3zli0/h8/i5597dnGl8nrU7VmKP/DEegJzEZM4N91KkS6dh0ERVhoHjPW280lTPvvU7sTjtPF1/mPohE6+3XeBAx0UhJFE/aCInUcc/r9mG2WlnaaaB723du6hWqX7IhFah5On6w8SLJTy56xNsLVqyyOrJTkzmnpUbruHwZuuQYHGNuZ1cb6wIO1Q+D3evqGNTYQV2n2fRfZI2LwONA5SU5fHdx+6nyTrIUycP0rAgplaQnIZcLOG23eEoaMA//fZCwogeeeSRLpfTe3d8vERTVlHAwMlwp3h0NI1KJhcq4TYVljPucVJjMNIwZOIzq6KTr0oRi+JQuEHRPcOwx0HR0nyWritn+w1rYSqI1+blVH8nn6vZzO8vfoBMImVPxUpyk1KYv3KFsjQ9krg4PujvokiXwe6KFRRoU7m9qpa3Oy8JB6NhqCc8r2HMTHBult7JMdzTAXaVVrOpsJw0lQaTbZRV2QWIYmM52tOKI8Idqng5raPDDE7ZKEvTs6mwHNPkKN/ZcivPnD2Kw+8lV5uCM+DnlaZ6QfHKJRIsTgdjHid3Va+lNif8/kdMLYy0mqneuERohbp4uZM0lUawturyS3ET5OHvh2uP4mXSbwJdCwlAfLzkOYfDdVd2TrpanpyAZGia5pFBYaJtFPK0KVicdmEIRpI8gZbRYRIkUqZng9xSsYoO6zBHj55jrs0JKfEUV+azfEsV4jQ558+30WsdRS2TRayZKTzBgNCULRHFccHch1gkIl2ZSMNQD42WPoy6dKoyc5n0e4RQdHaiDrlYIpSwm2yj3LG0lhcunUYukfLpFRtIlCt48dJpjLp0bihZymykyvpYT5sQe8rWJHPlypVFw17NLjsqmZxV2QXcXL6CVdkFmF3h9za7HMJ+Afonxjlb38Jdn7qBDXUr6L34/1V35XFNnen6QchOQkzYSRDKpgHCLoJYN1xvtUVbl6Kt2l+tM/3dVkft7eJ06vTOzK9j22lnbPXWtrY643bHsW7VW1yw4wUdBVFRNELYIQYSkhOykEC4f5ycjyQsgkvtff7jZOHk/Zbzfu/7vM9bgzIVXeo6T5GB8uZa5C/Iw+RpmbDbHTZfX1+PniuMVoSNx+Pu1OuNhcr0hIBOTg/K/1lJ/gmzJz6dmIkjN8vIdZavL/RmE263tWJmghKmLhv+cv4kJseMQ7QgELeKb+GD3fuQk5eK1PSxWLW6AHw2Bw13mlHbpkViqAxZ8hikR0Sj29mDHRfPECOUNamh7aTo580oX+RFxeNaawMSQ2V4OXs6siNj6XoEt7020SXUpzEZcV3TgCvNddBZOqGzdOJM9Q1UahrJM2VRSg564KQT7HW3QdmsiJYGY/OsRSh1qXWNC44A29cPu8p+JDuC1WHHKzn5mBmfQvLEbdoOzI5WIiQlHHFJUTjyXTG6uuxIj4jGvMRMTF89DUHBo2EyWQ5zuRwPYpC7WoqNx+Pu7NBThSkZCQEBwSKi0X+psQZqvRYnblVg/eSnEOgKT9fq28hgqNpa0dXjQJQkCBUt9bjcpEZOVAKOXLiArVv3QezLQ2qOAglpMRifnwZfRy9mjE7AvislOHC1FCoX4xgAPnn6RSLO0WjQoaGjHUvTJqLb6USVthlhIjF2l/2Iay19dcxMjlnV3krIvNPjklGr15L30Bmp6XQ1JIeHMaODsL+ihFRlVrTUI1IciFqXbqnWTGF8ZCxu3G0iDHH4+CB6dDC6ehwkBclnsRFoYsEu8UV6tgLjo+NQ+mMFbre1YuLEVExdnEdvP1xOIbxkLL31gmw8HmenQUe9mJ6lEMojQz36Ok6PS8LV1gY4e53QmAwkLwoA2WNisTJrKraVFIGyWTHetQcX19xEblQ8FL2B8OH6Ijg2BEKRAJPyM9EhdeK2ugHPRKYSj0QuluLA1VL8fu5SD5HX0vo7qNVr0eN0wuqw40J9tQdN3ep1aqVXqB90FhNEPD7SIqJg7KLruXTmTpTWq3BOfZOsOMajYkRjGf1QPptDvCimpqy8uZZoVTM1zSV1Kpw6dRHzC6YiITMW4I7CWGUMkqclQiYPQafJUsPmsN6GFwZSzLJxVJf0sgAADSVJREFU+Zyv9HpjYUaWIsB9EGr1Wmg7jbA47FiVNQV+vr6466qtTQkbgz1XzhMDPJ2YiUpNIz3buHyECsVQ9eiQ+2SfrHKELBjzFk6FU+iLi2U3QFFmvJKTj9ttrTh2s4zw9mnaRzhqdLRxlqZNhLqjjQTumBXgHY7WmAxEFITP4uAJaTCpBx5M1Nu92K/dbALVZSUTjQlOAnRU4FllNs5U953qfZ3AnQo1nl6Sj7SMcZiQq4RMTqdX2RzWegxTsgxgtiO3lSBu6UWtXgsRjw+d2YRz6irU6rXIioyB1WHHiqzJ+JsrNQcATUYdVo6f4mIDtIA1yg+vvP08hBJ/HDtYjNbjKuw5WoR4RTTGpsViyfOzwedx8dn+7zBhTBxaqQ7w2GzSNKHSVVMAAMsyJuFOWyuhrMjFUhSm59Fem0vnwtuoGpMBtXotYgNDYXPY+w2A+7YH0Fsq1WUl3yUXS6ExGcFnc5Afl4yKljqkR0Sj3UKhp7cXVocdS9MnYk5kMi43qZGU2RdCN3dadWw26/mBDD2UaqKN57YSKLYDF4orSF0XA6aa5tjNchKltDrsCBWKca7mJipa69Fk0GF2wSTMWDgJF0uuYdUL76KurhUXym+g9nw1VJoWTMhWYsKTKXhu6SzwrD64raons9a7JvjYzXIYrGZkRdKn7gXJ43G2phKvTpyFnl4n8YwYuG9nf5i7FFKBELe0zShIHk9ESNyNPxCWpU/C5cYaULY+r61ap0GQvwiBAjrn22TUo8Nqxl8P/w9e/VWfvdls1qu4D9lKehB43J0GHbU8PUshCgwdjcNHivvNHkZAe0pMInx86GKP6XHJSAgORyBfCI3dhK3fbAKHw8aSgo2gKDMRwJP7S7Dr8En4VpvhZANj02IxNi8BTz6Zgaob1bhyh1a+Yvn64Ze5M0kZaahIjNfy5kBnMeHA1VJoOylcbalHlSvz5o7TdyoxT5HhYuLpcV3TAKlAiML0vAF1JwB6S3t90hzUd7SDsllxya23AAPm2WFx2JEQFI5avZZobKzdSHubFoutjcXyKxzMwMNtZch0QI2oOleFOYvWkhf4LDYy5DHQUB1YkTUFav1dfHXxLKQCIVZlTUWR6hqmFE7C2g3LcHTPafz7uj8SpanUiChUNNd5sBMm5CqxbuNy0jH76x2HwC2j8M35s8SFTA2PAp/NHpKYG+uSjHEP2DFYlJKD8uZaVLtiRHKxFPMUGWh3JWEIb8h1n8z9/aVgJUrqVES5PT4ozENfCKAnozOci32HtjCXpsIt9uON4Yp327h8ztd6vbEwcpzM48HscPbAbO9Ck1EPWYAEihAZilTXYXXYMWZ0IGz8Xvxx20ZYOm049+fTsFhsSAyVEVVF5oHIuHh31I34+/4icG0+dEuTXCWinoxDi14PcwMtdcnkiD3lMz3xh7lLUdFShzljU/v1EKC6rBBzBeSgSdmsUOu1SIuIQqeLsTcjPhkqraeEWY3uLlqMenKy1llM8Odw0dPrJKvO2NuFXft/D5FIALPZup3NZn02lGFH2sxTbGinqsSBotCD+4tw8OMjmB6XhPeL6Lonb8ogn8XGiZOfY0ySHLf+fhX/OnoZvj6j8O3lc8SzsDjseHPaMzheVQaD1QIpX4iKljpIBUI4/HqxanUB1m5YBgDQtLTjy/f34Mt/HB/47txAk4yvQxEqA9ePhfO1twd9L6NXxxibz2IjNyoBJXW370n04rPYHuRips26xWJr4/O58bhHe6uRtjAxiANF4wxao27h4hlY8+4y3Nb2xe+lfKEH0TZ/ajbGJMnRqr6L1977E9S6uzheVQ5VWysSQ+UkmV7WpIbBSkccSXLEbAJl7MQnW3YjL/MFFJ0sRWh4IDZtew37D20h7t1gOHqzDBaHHeMjYxEkCBjyvQydhIHFYSdUend496Zk3ssYf0KukvS45/O5izCM3mL300HDxhVwv+jQU4VjU2ICuvjA98fpeMvitFxwfFmk3HPfoS3g+XPx8qrN8DH1oNNug4QvdJ2au0l0sd0llpcXPRbT45LRQumxJmcGGgz0A5CizDj6XTHU1+oRpxgDZVoCVq0uQGpEFHq0VvBHsQeVOrvUWINb2uYhfxAjaTZQuxOAXiESvj/Yfn6DqrSIAvzx3YlPweGwYaLMH3A47C+HY8z77SFj4/E4O/V6Y2FKxtgAeWQosrvD0GBoJ9TxVasLMHteHoqLLmHrp3uhMRlgdtjRaKTrjNMiosD1Y6G710l0nTVUBxKCwnBd0wibw9FPtcuiM2Pr9gOgKDOys5MQmxGDKc/kYJStBz7t9n4x+MEQHxSG9VPmEdeUslnRYjKgZ4AicIDWLRV4UeG9sWvf7/BErBydJotaKBLMH64hH7ShM9GZ/uHweby17hPozCYszs7Db/e9AQ6fg7zMFzBR8gSJ0zNg5A8AEM4mQwWZp8jAD6pr4LHYJBPGQBYggbXbAYdfL9ZuXEaWvKqqDu++/RkuuDotjRTM1jnUns8k7RnGOJOrWPvblVi4eAbsXQ47m8NKgJc88VB4GB21ySA032zGf39/Fi8ufwqjQ8T47OO94F+hI5HJoXJ8c6mY/MBM+RPo7nFCZzEhISh8wAeeMiwSzVQHEXcF6CZBRpuF/C2Th+BPW98g1TlFJ0uxedM2NDV6ljfR1Mp4D6WveyE1PAqNRp1Huam7W8pnsfHSmoVYv2kF85GVGGEf+ofV0pzuLyMRydwvvjrrHcyPTcOOi6dxuVGN+KAwJASFk9kzMSrBowWJN9zLj4a6JhUIkTstDW++9zIiZMEwUWZ89cUhfP3FIfeaXFpiwMUA9OYGMbN7JGVOzy6ZiQ8/XQ8AMJut2wUC3i+G/WEXHmZPebISmAu/mPwfqG7X4E67hvD8V2RNJjR1qUCI3DHxZPtZkDweap0WUoE/Klrq+xkjNyqelC8NhrUbl+Ol1QUQigRobtLi84/34NCB030VoK504lCGvtd2FB8UhgWL87Hm17R7rNcbiyWSgKlDGWcwPMxuqgaJJEDZoaOIXxocHkgYCRUtdahoqUOlptHDVXWvaowNDEVFSx1O36nsVyjNRCeHMj4AfLJlN/InvISSE5cRIQvG7z5ei90HPyD5bp3ZBCnff0AOJwOZWNqPb+p+n8vXLSDGt1hsKokkoGDImxoCD3MFMCAr4drlW5j/b68DAJ5SpKPJQHesY2Y84Fk16Y6Btgnmuvs+7A3mgc5nsSGUifGb99eQsMbB/UXY/OvtYHX7DPkdA4E5GP7m/TVY6Opr7Jr5BbjPXsLAo+mobZBIApSGNqpdmTkWWz9/CwAdwdRZTIRYC8BVvCCgYzssNtGaA4AEV293pg7ZHe6z0xvM9zcadLhZWYPFBRux4fWP0NykxcLFM/C/l3dh+S+fGdT4UoEQU2IU/a7nKROx/9AWYnybrWuva9u5b+MDj2YFMBAb24zVAUEB0uJjF2A8osZb3+/1+OEM4fajc8f6KWcNhtTwqH4y8/cCn8WGUCTA0lVPeTwfNm/a5pHxA+gBkPAEHmSumXNy8dGfNxBibUcH9fbo0aIBm/KMFI9yAAC6AVzlaKko4ta5Wziz7TS2uqjt0+OScdp13F+UkoPSetU9tUCBvlJRppJ/OF6Le58CmTwE6zYuJzP5Ysk1rH/tw35uK0Cfbt3PGna7w8Zms5bCTf//QfEwGjoPBRuPz/na0E6tlCki/CNkITh+/J+kgJphr0VLgzEtJgn2nm6S5WJYboyANwP3hpuMlue94FGxQpnxw4kSXCih9URTM2i2hkjsj5o7jaAoM+KDwpAxWYkd376HyVNpXSMTZS7j87mTAVx4mAZ61CuAgUdnpuLtZ/vF6WkhqHCPgw/gSRi+F4Yj4OGNFS/Ox/pNK9x5+/1goswfCEWCN4f9pSPATzUAgNsglJ+6ig/f+ZJUorhjJAa/X3j/jwm5SvcECoGJMpcJRYJnMYLQwkjxKLygwWCQSAKUer2xMT0/BQt/NZ/EfuaOSyN+/6M2PkALgjCQyUPw3JKZHq9bLLY2AAVCkSATj9D4wE+7Ahh4bEeqvRUIEojwn6f+QStbeaUoGTCaRcN5UA8HM+fk4rklMzFjdl9ttLnTqhP48zZghPGcB8HjGACA7tB6WxwUEMwcjpiYzVCD8KCYkKvEzLm5mDVnIiJkweS6K3v1Bn5CwzN4XAMAuK2EqhtqbHlnB86UlmOhMhutVMdD2YoUSTFQJMVg1pxcTMhV9nvQGgymg2KxcCuGSJo/ajzOAQC8AngH9xdBdbEa//W3Pjeb8ftTI6IGHRRFUgxEIgEUSTGQRYYgMZE2/ECejSt88C1oX/6BTrEPA497AABAbKLMp4QigUfMoeqGGpSxE36+fnD2OuF0Oj0+NJiBvaHXGxtHjRr1L7FY+FfQM/2xG90dP4cBYLDC3Gn9UODPk977rQNDrzdeddi7G0JCpeWgjV2Bn5nBvfFzGgAGqaDbe6QO8roBnjQ/77//X+H/AAKopZ6RT3FZAAAAAElFTkSuQmCC',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'5626bed4e756430ba7ffca78c8b12738' => [
				'name' => 'VALMIDO PRO FIDO',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'260e3021482d442d838c7edfbe153b7e' => [
				'name' => 'Feitian ePass FIDO2-NFC Plus Authenticator',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'95e4d58c056e4a65866df5a69659e880' => [
				'name' => 'TruU Windows Authenticator',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'90636e1fef8243bfbdcf5255f139d12f' => [
				'name' => 'YubiKey Bio Series - Multi-protocol Edition',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'9c835346796b4c278898d6032f515cc5' => [
				'name' => 'Cryptnox FIDO2',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'c3f47802de734dfcba22671fe3304f90' => [
				'name' => 'eToken Fusion NFC PIV Enterprise',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'0d9b2e56566bc3932940f821b7f15d6d' => [
				'name' => 'Excelsecu eSecu FIDO2 Pro Security Key',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'2bff89f2323a48fcb7c89ff7fe87c07e' => [
				'name' => 'Feitian BioPass FIDO2 Pro (Enterprise Profile)',
				'icon_light' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFAAAAAUCAMAAAAtBkrlAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAABHZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMDE0IDc5LjE1Njc5NywgMjAxNC8wOC8yMC0wOTo1MzowMiAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iIHhtbG5zOnBob3Rvc2hvcD0iaHR0cDovL25zLmFkb2JlLmNvbS9waG90b3Nob3AvMS4wLyIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bXA6Q3JlYXRvclRvb2w9IkFkb2JlIFBob3Rvc2hvcCBDQyAyMDE0IChNYWNpbnRvc2gpIiB4bXA6Q3JlYXRlRGF0ZT0iMjAxNi0xMi0zMFQxNDozMzowOCswODowMCIgeG1wOk1vZGlmeURhdGU9IjIwMTYtMTItMzBUMDc6MzE6NTkrMDg6MDAiIHhtcDpNZXRhZGF0YURhdGU9IjIwMTYtMTItMzBUMDc6MzE6NTkrMDg6MDAiIGRjOmZvcm1hdD0iaW1hZ2UvcG5nIiBwaG90b3Nob3A6SGlzdG9yeT0iMjAxNi0xMi0zMFQxNTozMDoyNyswODowMCYjeDk75paH5Lu2IOacquagh+mimC0xIOW3suaJk+W8gCYjeEE7IiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOjJFNzFCRkZDQzY3RjExRTY5NzhEQTlDQkI2NDYzRjkwIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOjJFNzFCRkZEQzY3RjExRTY5NzhEQTlDQkI2NDYzRjkwIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6MkU3MUJGRkFDNjdGMTFFNjk3OERBOUNCQjY0NjNGOTAiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6MkU3MUJGRkJDNjdGMTFFNjk3OERBOUNCQjY0NjNGOTAiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz477JXFAAAAYFBMVEX///8EVqIXZavG2OoqcLG2zOOkwt0BSJtqlcXV4u+autlWhbzk7PUAMY9HcrKjtNbq8feAl8aBoszz9vpdjsGGqtF3n8uTsNSZpc6JsNT5+v0xYKnu8Pff5/L48fg/friczJgYAAADAElEQVR42kRUCZbDIAjFXZOY1TatNc39bzksSYc3r4ME4fMBAaD6zl8y/9TOget8d5jfN78bwM/dDCRpR521zXfojHJ05IIyhBAUSVAONdGzBYt2f7KFrfkJaAkHh9FZhcDXHRkTKo9MLihGaavImnV3qyEX0Eprgz/4DwUD7kCHRnd8QFN43Go4UVmDDgza4w27oizdA2+cK+uuUpjjo2+xwc/42W50x5LGYeDBsR0HVIx5x8iF60CblbTEEkFr27bNDBUVSq1OKVPbE62b3EH8FqBg5OOOEuc2t8ZJiqMOuGp+cKjg7wVGceozqN4pxgVPQkjFYgbVJKDUhDCjYrawP5q4ETgC9fIMRHtitpQcCvJOELcbMsQgnciRkljpyQjvG44jqBUETFiBi1PEIyekOzsW+Ty5cLHos5R+dMS1LtSSxf3gQHczR2CI4gMNpW4IRA1QMa6tJ4+C6uHuGE8mNDIyFqg/OP/MMUueS6Iq8S90dAeBJSEy/qKkK+BNwz8cYY4jb5J6u4iWCI2B1Z56LW5kEc4hkdMpsvUC5585SX0QubcgNqyfgDFEcTt+40/0S5Nx0waCw3OKkcObA5In0AYp01pjjw2n626UDjtHwa28iHuTKqtrv+reW41NZ6iGlr7uuLJCfkFtctcG04sgm1eNS+ZaDnpaTErGoyX5JK2iMz8xs0nOwWGcPDN49qaCd4bzJozDZm/aBK+EozLw+XhNBiYwHf0siOu1XPkG/zKwvqYKcfSwDEcH/oUe07es/WQ8rIyg2DOXj8tjkZduDB/b8hzDllMMOCS5BEnd534f8ti3UZc4kMs3xLyafMSsJhdG8XPqjNk5tAgO25feKChnVdDj/J0FMkOsU/xMBv0wFhYeEGfVH13fuDU0yDFLa4fc7RnWHBfuTFV2tEmNwadc7ac3UY2jfBl7HT36fe34iQO5mNCFFBW07KjPgqhOLU01vZ8PueZ2JClFZN8jkUs69uka9ePp6+EfL4AF5+NywSbirHtcB8Ml/gkwAEjkK64KjHPeAAAAAElFTkSuQmCC',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'c5ef55ffad9a4b9fb580adebafe026d0' => [
				'name' => 'YubiKey 5 Series with Lightning',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'2194b428939740468f39007a1605a482' => [
				'name' => 'IDPrime 931 Fido',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'39a5647e1853446ca1f6a79bae9f5bc7' => [
				'name' => 'IDmelon',
				'icon_dark' => 'data:image/svg+xml;base64,PHN2ZyBpZD0iTGF5ZXJfMSIgZGF0YS1uYW1lPSJMYXllciAxIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA1MTIgNTEyIj48ZGVmcz48c3R5bGU+LmNscy0xe2ZpbGw6I2YxNWI1Yzt9LmNscy0ye2ZpbGw6IzkyMWIxZDt9LmNscy0ze2ZpbGw6I2VlMzAyNTt9LmNscy00e2ZpbGw6I2JiMjAyNjt9PC9zdHlsZT48L2RlZnM+PHBhdGggY2xhc3M9ImNscy0xIiBkPSJNMzQxLjg3LDEwMC4ybC00LjI5LTEuNjRjLTMyLjMxLTExLjgxLTY1LjM2LTEzLjI3LTc2LjkyLTEzLjRsLS44OSwwSDEyMC4xMkEyMy40MywyMy40MywwLDAsMCwxMTEuNiw4N2MtLjQxLjIxLS44MS40Mi0xLjE3LjY0bC0xLjg1LDEuNzYsMTMzLjM1LDY1LjgsMTAzLjM4LTUyLjg5WiIvPjxsaW5lIGNsYXNzPSJjbHMtMiIgeDE9IjI5NC41OCIgeTE9IjEzNy4wNyIgeDI9IjI5Ni45OSIgeTI9IjEzOC4yNyIvPjxsaW5lIGNsYXNzPSJjbHMtMiIgeDE9IjIzOS41MyIgeTE9IjE1Mi4xMSIgeDI9IjI0MS45MyIgeTI9IjE1My4zMSIvPjxwYXRoIGNsYXNzPSJjbHMtMyIgZD0iTTEwNi43NCw5MXEtMi42Miw0LjItMi4zNSwxMS4yNnQuMjYsMTMuMzdWNDIzLjIxcTAsNS43Ni0uMjYsMTQuNDF0MS4zMSwxMi44NGExNC41NSwxNC41NSwwLDAsMCwxLjE0LDIuMTlsMTM2LTI5OS41NkwxMTAuNDMsODcuNjVBMTEuMjQsMTEuMjQsMCwwLDAsMTA2Ljc0LDkxWiIvPjxwYXRoIGNsYXNzPSJjbHMtNCIgZD0iTTM2MS44NiwxMTEuNTNjLTIuMzItMS41NS00LjctMy4xLTcuMTMtNC42OGE5My45Miw5My45MiwwLDAsMC0xMi02LjMyYy0uMjctLjExLS41NS0uMjMtLjgzLS4zM2wtOTksNTIuODlMMzg3LjYzLDQwMi4zMUExNjQuMDcsMTY0LjA3LDAsMCwwLDM5NywzODguMTJxMjkuODItNTEuMjEsMjkuODItMTI1YTI4NC44MywyODQuODMsMCwwLDAtNy4wOC02MS4yNSwxNjQuMTYsMTY0LjE2LDAsMCwwLTI2LjUzLTU5Ljc1LDEzNC45LDEzNC45LDAsMCwwLTkuMDUtMTEuMzhBMTUzLjIsMTUzLjIsMCwwLDAsMzYxLjg2LDExMS41M1oiLz48cGF0aCBjbGFzcz0iY2xzLTIiIGQ9Ik0xMDYuNjUsNDUyLjM0YTEwLjA3LDEwLjA3LDAsMCwwLDcuNjksNS4xOWwxLjc0LjJoMTU2YzUwLjI3LDAsODguNjQtMTguNjksMTE1LjUyLTU1LjQyTDI0Mi44OSwxNTMuMDlaIi8+PC9zdmc+',
				'icon_light' => 'data:image/svg+xml;base64,PHN2ZyBpZD0iTGF5ZXJfMSIgZGF0YS1uYW1lPSJMYXllciAxIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA1MTIgNTEyIj48ZGVmcz48c3R5bGU+LmNscy0xe2ZpbGw6I2YxNWI1Yzt9LmNscy0ye2ZpbGw6IzkyMWIxZDt9LmNscy0ze2ZpbGw6I2VlMzAyNTt9LmNscy00e2ZpbGw6I2JiMjAyNjt9PC9zdHlsZT48L2RlZnM+PHBhdGggY2xhc3M9ImNscy0xIiBkPSJNMzQxLjg3LDEwMC4ybC00LjI5LTEuNjRjLTMyLjMxLTExLjgxLTY1LjM2LTEzLjI3LTc2LjkyLTEzLjRsLS44OSwwSDEyMC4xMkEyMy40MywyMy40MywwLDAsMCwxMTEuNiw4N2MtLjQxLjIxLS44MS40Mi0xLjE3LjY0bC0xLjg1LDEuNzYsMTMzLjM1LDY1LjgsMTAzLjM4LTUyLjg5WiIvPjxsaW5lIGNsYXNzPSJjbHMtMiIgeDE9IjI5NC41OCIgeTE9IjEzNy4wNyIgeDI9IjI5Ni45OSIgeTI9IjEzOC4yNyIvPjxsaW5lIGNsYXNzPSJjbHMtMiIgeDE9IjIzOS41MyIgeTE9IjE1Mi4xMSIgeDI9IjI0MS45MyIgeTI9IjE1My4zMSIvPjxwYXRoIGNsYXNzPSJjbHMtMyIgZD0iTTEwNi43NCw5MXEtMi42Miw0LjItMi4zNSwxMS4yNnQuMjYsMTMuMzdWNDIzLjIxcTAsNS43Ni0uMjYsMTQuNDF0MS4zMSwxMi44NGExNC41NSwxNC41NSwwLDAsMCwxLjE0LDIuMTlsMTM2LTI5OS41NkwxMTAuNDMsODcuNjVBMTEuMjQsMTEuMjQsMCwwLDAsMTA2Ljc0LDkxWiIvPjxwYXRoIGNsYXNzPSJjbHMtNCIgZD0iTTM2MS44NiwxMTEuNTNjLTIuMzItMS41NS00LjctMy4xLTcuMTMtNC42OGE5My45Miw5My45MiwwLDAsMC0xMi02LjMyYy0uMjctLjExLS41NS0uMjMtLjgzLS4zM2wtOTksNTIuODlMMzg3LjYzLDQwMi4zMUExNjQuMDcsMTY0LjA3LDAsMCwwLDM5NywzODguMTJxMjkuODItNTEuMjEsMjkuODItMTI1YTI4NC44MywyODQuODMsMCwwLDAtNy4wOC02MS4yNSwxNjQuMTYsMTY0LjE2LDAsMCwwLTI2LjUzLTU5Ljc1LDEzNC45LDEzNC45LDAsMCwwLTkuMDUtMTEuMzhBMTUzLjIsMTUzLjIsMCwwLDAsMzYxLjg2LDExMS41M1oiLz48cGF0aCBjbGFzcz0iY2xzLTIiIGQ9Ik0xMDYuNjUsNDUyLjM0YTEwLjA3LDEwLjA3LDAsMCwwLDcuNjksNS4xOWwxLjc0LjJoMTU2YzUwLjI3LDAsODguNjQtMTguNjksMTE1LjUyLTU1LjQyTDI0Mi44OSwxNTMuMDlaIi8+PC9zdmc+',
			],
			'664d9f6784a2412a9ff7b4f7d8ee6d05' => [
				'name' => 'OpenSK authenticator',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'3789da91f94346bc95c350ea2012f03a' => [
				'name' => 'NEOWAVE Winkeo FIDO2',
				'icon_light' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAACqUlEQVRIx2P8//8/Ay0BEwONwagFpFlw8cKFirIyR3t7S1Oz0KDgBfPm//z5k3izvn39lp+Ta2tltWTRIoTofxhYtXKllpq6srwCAikoRIVHvH379j9x4NSpU0AtQI1W5hZwQagPzp87V11ZiXAvIxj9Zzh54kRNZRWRPvj96xcDOM0zMTKiB9G8uXP//fsHNFRASLC+sXHm7Nlubu4Qm3bt3Llu7VpiLGCEmcuIacGZU6fB4cWQX1AQGx/n7OIyaeoUbV0diIvamluePXtGUST/+g32HSODhoYGRISFhaWppYWVlRUo+OHjh6b6BoosgHvqz58/cDl9ff3M7CwIe8+e3atXrqQgmeIokDKzs/X19EGy/xk6OzofP3pEWUbDsAYYRC3tbRwcHED2h/fv62pqCReOjCTmZE0trZy8XAj78KFDy5YuJd50VAsYcepKTU83NjWBqOnu7Hxw/wE+O/7jsgC315mZmRubm9nZ2YFqvnz+0lBfhzOg/qO7lQm/B+EAmHwLioogCo4cOrxk0WIiPUEgkpFBUnKymZk5hN3T1XX3zh1iYoKJcDTBA4qFubmtlYubC8j++vVrTVU1qHQhzQeMBHyhrKxcWFwMUXn61Kn5c+dSv8JJSEy0trGGsCf099+6dQsuxcLCCrH7P5IrSYgDeKFS39TEx8sHZH//9r2uGhFQN65fh2VPNoqqTCUlpeKyUmgxfPpMSWERMAMuX7asv7cXIqilrYXwFrxeg/qOuGZSdEzM3t17Dh06CPT0pk0bN23cCI9FYKZJz8hE98Hff38hDDY2diL90dHdpaurixawrCysre3tunq6iLTX0NAAToIsTx4/tndwiIyOAtYExFjAzc3t4+sLJL99/QosE0VFRe3s7RtbmoGVFUqcjTYdh78FAIhBLlNd7ju1AAAAAElFTkSuQmCC',
				'icon_dark' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAACqUlEQVRIx2P8//8/Ay0BEwONwagFpFlw8cKFirIyR3t7S1Oz0KDgBfPm//z5k3izvn39lp+Ta2tltWTRIoTofxhYtXKllpq6srwCAikoRIVHvH379j9x4NSpU0AtQI1W5hZwQagPzp87V11ZiXAvIxj9Zzh54kRNZRWRPvj96xcDOM0zMTKiB9G8uXP//fsHNFRASLC+sXHm7Nlubu4Qm3bt3Llu7VpiLGCEmcuIacGZU6fB4cWQX1AQGx/n7OIyaeoUbV0diIvamluePXtGUST/+g32HSODhoYGRISFhaWppYWVlRUo+OHjh6b6BoosgHvqz58/cDl9ff3M7CwIe8+e3atXrqQgmeIokDKzs/X19EGy/xk6OzofP3pEWUbDsAYYRC3tbRwcHED2h/fv62pqCReOjCTmZE0trZy8XAj78KFDy5YuJd50VAsYcepKTU83NjWBqOnu7Hxw/wE+O/7jsgC315mZmRubm9nZ2YFqvnz+0lBfhzOg/qO7lQm/B+EAmHwLioogCo4cOrxk0WIiPUEgkpFBUnKymZk5hN3T1XX3zh1iYoKJcDTBA4qFubmtlYubC8j++vVrTVU1qHQhzQeMBHyhrKxcWFwMUXn61Kn5c+dSv8JJSEy0trGGsCf099+6dQsuxcLCCrH7P5IrSYgDeKFS39TEx8sHZH//9r2uGhFQN65fh2VPNoqqTCUlpeKyUmgxfPpMSWERMAMuX7asv7cXIqilrYXwFrxeg/qOuGZSdEzM3t17Dh06CPT0pk0bN23cCI9FYKZJz8hE98Hff38hDDY2diL90dHdpaurixawrCysre3tunq6iLTX0NAAToIsTx4/tndwiIyOAtYExFjAzc3t4+sLJL99/QosE0VFRe3s7RtbmoGVFUqcjTYdh78FAIhBLlNd7ju1AAAAAElFTkSuQmCC',
			],
			'fa2b99dc9e3942578f924a30d23c4118' => [
				'name' => 'YubiKey 5 Series with NFC',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAfCAYAAACGVs+MAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAAHYYAAB2GAV2iE4EAAAbNSURBVFhHpVd7TNV1FD/3d59weQSIgS9AQAXcFLAQZi9fpeVz1tY/WTZr5Wxpc7W5knLa5jI3Z85srS2nM2sjtWwZS7IUH4H4xCnEQx4DAZF74V7us885v9/lInBvVJ/B4Pv9nu/5nu/5nvM556fzA/Qv0Hb/IrX3VFKPo45cnm4inUIWYwLFRmZQUuwjFG/N1iRHh1EZ0NRVRudqt1Bd+2nSKyS/Ohys0+lk3e/3kQ9qvD4ZUta4VVSUuY0eipyiThAfocoORVgDuuw3qKRiAd3rbcEtjTjYIof6WaHsCmzVPWCMx+cgh8tLqWMKaMWsUjLqo2RtJIQ0oOzmerpQu4esZgsONkGxH7d0kdvTT17s4OMU7VI8ZhjgGaM+Aq9iENu8Pif1udz07MwvKWf8GlVoCEY04PC5WdTaXYFbR8vNvL5+3Kgfb5xNMya9RamJiynaMlGTVtFlr6ba9u+pqnEX4uMuRRgjSYEhrN7utFFe6lqal7Nfkw5imAGHynPpbk8VmY0xstnptlFCVCYtzTuBN83QpMLjTtevdPzSUnJ7e8mkjxZ39fXbKDfldZqbvU+TUgGnBVF6fQ2iPHg4W16UWUwvzbk16sMZE+Pn0pvz7JSeuAyes8lcpCmaKuo/p+qWr2UcwIAHWrvP0YEzhXAtLAbssHhp7iGamvyijP8ryqrXUWX9XoowxyAufNBrp43POBFXZlkf8MDRiqcpyowAwpuz2x+fWvz/Dtde9smszygtcR6C1wbdzBl6Olq5WNYY4oGathJMrkTEx0jARSHAVs+5rYkQNXb+QgfPLsQ6gXyInsreQfmpm7RVFYfL86n1fiUOkYvShkUPxvbukzoy6K1ihM1ho3XzW6EvSfXA+dpiWGaWd+doXzLzmGwKYFLCAsRAlPBAhMlCFXU7tBUVPr8HgVcJHWq+F00plr+DMTdrP4zvxY11kNMhxT+SeTGg+d4V5LQJityUGJNB8VFZsjgYBZM/II/XCTkj0qyDOpF2AVQ17CIjUp/DnT1UkL5F5gdj+sS1wg1gE3gigm60fCXzSnPXbyAPbIXv+IDpE16ThaHIS9skyhlmME5F3cfqAKhq2C0E5PH1gYaXaLPDkZG0HDJOnKWHp51I0z5SOux8e1WAuZzdHQrTkp8TmjXoI+la0wGZszubqbO3ifQ6A/W7vVSYsV3mR0JKwkKc4WHiBkmR8I3CCgI87oOL4qzT5P+RUJBejEOgAPK8hYPzatM+eITp2IO9yTQmeromPRxx1qxAcsile/ubSeEbcWQGYECghcLY2HyKjogjH25hMpjpUv1Ougli4eh2eRw0O32bJjkyuCgNzg0vzlYMSiSs0uoo4MG7hMOjCEaX1yFE0nSvjBzuTnEpK86Z8IoqFAIubw8kg9ArEaREWSZI+jH4Xbp6g9E9EnJT3oaRzDN+MUJBQDHn56a8oUmEBusOxBs/N5+tJEbPkAFDj8UGvOs/IWvcSglGBhvS7/FTYfpWGYdDY8fPAxWSA35sTC4p4+Lm4AaqIoPeQtfufK6Jh0ZhxlbsUXOSmXNifD5ZTAkyDofbbcclxnA8WNAqxCbRNykhXxQpaDw67fXUYbsiG0Khtv2oeIvh8rhQMYOcEAqXG/eI+zngOc5yxr8q82IAM1c/FLFOplqu5eFQXrMZzGcVCjYbLWG5I4BT1euRrlbxtNOtMitDDEhLXIIynAAvuOEWE3X3NdAft94VgaG42XIQt0ZX6PeCE/qQFe9rK6Hx7YU50KvH7fW4fS+q7KKBJxsggBX5pSAGh1jIrVh5zQ6w3RfaahBXm/aCbCZTjCUFUTyWZqW9p62MjJPXVqOrPgMO4Nv74Gkf+owftNVBDQnjFJqHSw17pXvhWW5KZqe/Q49N/USTCAVWoQXFIHBHXXe3FPrUDsuGDmtF/hHKTHpekxhiAOPI+SJq6S6HF4I9YWzkBJTo46iUMzWp8Pir/RiduLxKYsSksV8vLlOQvhGX2YlR0OBhBjC+u/gEcvY0ApK7Yk41NxjPSQnWFHTF66UrjgevB8Cu5a+l2vYSRPtuVDo73hhdMSHnUX7tTjsVZGxAl/WptiOIEQ1gnL29mX6/tR1tmlkYj8W4X+CSjWcUDGY1NpS/C7hSKqiMLM/l2QmSWZ73Ddz+gio8BCENYPQ46qnkzwXUbqvBkxjUQsWfZFgbuo3rAf+wN7jOO90+ynx4Pi3L+0nYL1SchDUgAP4gPV/7Id1q+1HShmuGkIqWRPgyxMFqP8HfjTnjXwY5bQfbJct6OIzKgMHotF/He1egsaxHSqG6wfdmQ5x8NyTFFqBcp2iSowHR3yk5+36hF7vXAAAAAElFTkSuQmCC',
			],
			'341e4da93c2e81035a9faad887135200' => [
				'name' => 'Ledger Nano S FIDO2 Authenticator',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAASYAAAEACAYAAAAeMdvxAAAAAXNSR0IArs4c6QAAAIRlWElmTU0AKgAAAAgABQESAAMAAAABAAEAAAEaAAUAAAABAAAASgEbAAUAAAABAAAAUgEoAAMAAAABAAIAAIdpAAQAAAABAAAAWgAAAAAAAAEsAAAAAQAAASwAAAABAAOgAQADAAAAAQABAACgAgAEAAAAAQAAASagAwAEAAAAAQAAAQAAAAAAe6SCkwAAAAlwSFlzAAAuIwAALiMBeKU/dgAAAVlpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDYuMC4wIj4KICAgPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6dGlmZj0iaHR0cDovL25zLmFkb2JlLmNvbS90aWZmLzEuMC8iPgogICAgICAgICA8dGlmZjpPcmllbnRhdGlvbj4xPC90aWZmOk9yaWVudGF0aW9uPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KGV7hBwAAD65JREFUeAHt3LuOJGcVB/Bd9mIHNhLiIhOQOEaCCDkiICNG4g38CjwJCQlCBASIBN6ChAgJJERiJAvZAoyxfFnvhe/s9JFqe3tmuk9/p6d651fSN1VdVedUza9q/l299sydO3fuvD/GszGebOaxbKzX4NHm+vxqzGN6cDHzdSFwf7P88zGPeznN3Nfrva/j2jzdXK9PvzIWTAQIEFiVgGBa1eVwMgQIhIBgch8QILA6AcG0ukvihAgQEEzuAQIEVicgmFZ3SZwQAQKCyT1AgMDqBATT6i6JEyJAQDC5BwgQWJ2AYFrdJXFCBAgIJvcAAQKrExBMq7skTogAAcHkHrgtAvFLoqYzERBMZ3KhFqd5d7Oc88Umi5cIhBWvS3DWuDr/PMQx5+ad6Bi9w2vTO+eHd7g9FWmUf07j9nznN/+dHvVGEMXx95i+PUZcvH2foPKCR/1Px/jjGG+OEX/T6agTGvWmqwXC/t4Y/xkjrl145/UYi6YhkCZvjeVvjPF4s27MTE0CcQ/Gg87HY3x/jN+PEVOs3zcTct/PZjwx/WUc+L04A9PJBfIH8OQHXvkB8wb/5zjPGKbTCjw89nAzgumNzUnEycQTk6lfIAIpnnBjmHYLRDjFJ4AYsWzqF4i/pvr5GJkJ5SPOCKYMo5jncvmEFBKYKCC8J2Lu0So/ssVH56Omff9N6aiDKCZA4FYJZECVv2nBVKZTSIBAl4Bg6pLVlwCBsoBgKtMpJECgS0AwdcnqS4BAWUAwlekUEiDQJSCYumT1JUCgLCCYynQKCRDoEhBMXbL6EiBQFhBMZTqFBAh0CQimLll9CRAoCwimMp1CAgS6BARTl6y+BAiUBQRTmU4hAQJdAoKpS1ZfAgTKAoKpTKeQAIEuAcHUJasvAQJlAcFUplNIgECXgGDqktWXAIGygGAq0ykkQKBLQDB1yepLgEBZQDCV6RQSINAlIJi6ZPUlQKAsIJjKdAoJEOgSEExdsvoSIFAWEExlOoUECHQJCKYuWX0JECgLCKYynUICBLoEBFOXrL4ECJQFBFOZTiEBAl0CgqlLVl8CBMoCgqlMp5AAgS4BwdQlqy8BAmUBwVSmU0iAQJeAYOqS1ZcAgbKAYCrTKSRAoEtAMHXJ6kuAQFlAMJXpFBIg0CUgmLpk9SVAoCwgmMp0CgkQ6BIQTF2y+hIgUBYQTGU6hQQIdAkIpi5ZfQkQKAsIpjKdQgIEugQEU5esvgQIlAUEU5lOIQECXQKCqUtWXwIEygKCqUynkACBLgHB1CWrLwECZQHBVKZTSIBAl8D90fjLTfNHY35vjGeb13d3LC/XxW4PF/vEa9PpBOJaPBgjr9chR87rmNf+kFr7ErhOIO7JvLfy/sx7LmqXy8vXse/zTIov34wtY3r9Ynbw1/jhMJ1WIC9svJmYCKxFIO7LmCJXjsmFr0aDX48R4RQ3+b4f7TIF4+AfjBFTrrt45WuXQIbSt8YBfjzG48WBclusyptkeV1ye1z3/47xhzGejmEiMEMg76V/j2a/3TSM+y/vxeuOEftGBn1x3Y77bt/3wPv2s9/lAvFxO6YfjREXsjo+HLXxUTwm1+/CwdfjBabcS/HOGQl1TLNIyfjhMJ1WIJ+U4rN8XL99r2Fcr3jS/WgM120gmKYK5D2Vb6CV5s8imPIdt9IgavJEqvXqjhOIG2DfUFrut+/H9uPOTvVtFciPdaXvP4OpVKxoVQLL0LnqxHK/nF+1r20EqgJHPbB416yyqyNAoE1AMLXRakyAQFVAMFXl1BEg0CYgmNpoNSZAoCogmKpy6ggQaBMQTG20GhMgUBUQTFU5dQQItAkIpjZajQkQqAoIpqqcOgIE2gQEUxutxgQIVAUEU1VOHQECbQKCqY1WYwIEqgKCqSqnjgCBNgHB1EarMQECVQHBVJVTR4BAm4BgaqPVmACBqoBgqsqpI0CgTUAwtdFqTIBAVUAwVeXUESDQJiCY2mg1JkCgKiCYqnLqCBBoExBMbbQaEyBQFRBMVTl1BAi0CQimNlqNCRCoCgimqpw6AgTaBARTG63GBAhUBQRTVU4dAQJtAoKpjVZjAgSqAoKpKqeOAIE2AcHURqsxAQJVAcFUlVNHgECbgGBqo9WYAIGqgGCqyqkjQKBNQDC10WpMgEBVQDBV5dQRINAmIJjaaDUmQKAqIJiqcuoIEGgTEExttBoTIFAVEExVOXUECLQJCKY2Wo0JEKgKCKaqnDoCBNoEBFMbrcYECFQFBFNVTh0BAm0CgqmNVmMCBKoCgqkqp44AgTYBwdRGqzEBAlUBwVSVU0eAQJuAYGqj1ZgAgaqAYKrKqSNAoE1AMLXRakyAQFVAMFXl1BEg0CYgmNpoNSZAoCogmKpy6ggQaBMQTG20GhMgUBUQTFU5dQQItAkIpjZajQkQqAoIpqqcOgIE2gQEUxutxgQIVAUEU1VOHQECbQKCqY1WYwIEqgKCqSqnjgCBNgHB1EarMQECVQHBVJVTR4BAm4BgaqPVmACBqoBgqsqpI0CgTUAwtdFqTIBAVUAwVeXUESDQJiCY2mg1JkCgKiCYqnLqCBBoExBMbbQaEyBQFRBMVTl1BAi0CQimNlqNCRCoCgimqpw6AgTaBARTG63GBAhUBQRTVU4dAQJtAoKpjVZjAgSqAoKpKqeOAIE2AcHURqsxAQJVAcFUlVNHgECbgGBqo9WYAIGqgGCqyqkjQKBNQDC10WpMgEBVQDBV5dQRINAmIJjaaDUmQKAqIJiqcuoIEGgTEExttBoTIFAVEExVOXUECLQJCKY2Wo0JEKgKCKaqnDoCBNoE7rd11vgcBOL6Pxnj3hjPzuGEDzzHp2P/GKYzExBMZ3bBJpxuBlAE0mebfq/yD+/d8T3m9zyBT4tTCAimUyiv6xjxgxrTm2P8ZIwvx4iP9K/SD298L6+N8acx/j6GcBoIJgKdAvGxK6YfjhE/gPHkE088sbzvOHT/ffuubb+fDZOYHlzMfD0XAU9M53Kl5p5nPjVlQOXrCJaYdr2Obcsnj1zOfZ8X7viy7Jk9crfcFq+XfXK/3L7clrU5X+6Ty4/Hxnhi+iJ3Mj8vAcF0Xtdr9tnGD/zyh365HMdavs7lnG9vj9e7pqv2X25b1ub6nC+3bS8v98nl/K/N+Xq7xuuVCwimlV+g5tN7VX9wX9Xvq/l2WE/7fGdZzxk5EwLHCeTHueO6qL5RAcF0o/wO3iDgaakB9dQtBdOpxR2vW8ATU7fwCfoLphMgO8RJBTwxnZS752CCqcdVVwIEjhAQTEfgKV2lgI9yq7wsh52UYDrMy97rF/BRbv3X6NozjP+P6dgL6R3qWubWHfi/yBseTF40uYlXR+WKJ6abuGQ9x8wfxpznUS77Qd3eL/eP+XLbcjm35brL5tkrtx/6elkXy8vX2Svny+25X85zH/MzE4gnJhfxzC7a5nTzl3lznt/F9jvV9uvL9sv1MV/WLJcv25b75Dx7VV8v65bL2Xc5X27P5YebHfzy7lLqtMtH5UpcyN+N8dYYj8aIJ6hDGkawvTvGXze18Uuhpl6BuGZxjb42xg/GiL8uEFP+UF68ut1f4z6MX+L98xjvjZFmY9HUKBBvknE/vj3GLzfHOSRPYt/o8XnUfjxGrKiOd6LJmLbfuS/W+tohIIT2V2W1v9Wxe+YT6vdGo2qePK+LJ56Pxog/GpZPTGPx2imKY4oTiT8xYTqtQPjHD5w3g6vd48nJU/zVRjO3Zi7EU1M+yee6fY4T+0YmfRJfYsQU833/MXx5MO9Iz/lO/iWugTeFk7M74B4CyzfNuE/3zYjc9/6+QbTHudiFAAECcwQE0xxHXQgQmCggmCZiakWAwBwBwTTHURcCBCYKCKaJmFoRIDBHQDDNcdSFAIGJAoJpIqZWBAjMERBMcxx1IUBgooBgmoipFQECcwQE0xxHXQgQmCggmCZiakWAwBwBwTTHURcCBCYKCKaJmFoRIDBHQDDNcdSFAIGJAoJpIqZWBAjMERBMcxx1IUBgooBgmoipFQECcwQE0xxHXQgQmCggmCZiakWAwBwBwTTHURcCBCYKCKaJmFoRIDBHQDDNcdSFAIGJAoJpIqZWBAjMERBMcxx1IUBgooBgmoipFQECcwQE0xxHXQgQmCggmCZiakWAwBwBwTTHURcCBCYKCKaJmFoRIDBHQDDNcdSFAIGJAoJpIqZWBAjMERBMcxx1IUBgooBgmoipFQECcwQE0xxHXQgQmCggmCZiakWAwBwBwTTHURcCBCYKCKaJmFoRIDBHQDDNcdSFAIGJAoJpIqZWBAjMERBMcxx1IUBgooBgmoipFQECcwQE0xxHXQgQmCggmCZiakWAwBwBwTTHURcCBCYKCKaJmFoRIDBHQDDNcdSFAIGJAoJpIqZWBAjMERBMcxx1IUBgooBgmoipFQECcwQE0xxHXQgQmChwf0KvDLd7E3ppsb/As7Hr0/13v5V7xr1591Z+5zfzTUeePB7j6CyYEUyfbAwe3YzFrT5q/NBFQJleFggbwf2yS+eaJ5vmHx97kBnB9M44iYdjvDFGnJh3qIHQOEUQPRjj/TH+NoZwGghbU5q8PdZ/Z4wvx3BfbiFNfhn3ZeTJ/8b47ozecYNH0wiVmBvnYfCbca1iipAyvSiQb7i/GKvdz+djEE+4cb0+zQv44mU97FVe+MOq7F0RiHf9ePePJ9QvKg1uWU3+80LMZ9zrt4yv/O3GfXrUE+qMi5UnkPPt7yaCK7flcsxjivW57vmKHV92bc91yz7L0twe65bL+Xq5byxvn9/29nidx4rl7fNeHiOXt+fbPeJ1TMtjX6zZvS73zf1znjXmLwukUcyXy3ltoiKWY8rty20XW178utw/9835cs/tdfk651ftm9ti35zi/PL1vueatYccM2tynrU5z/Ux37Vuub28PCOY4uAJtetElttyOefX1V62Petzvn3c5frl8mX9sn5731y/q265767lXJfzXT2u6n/d/stay9cLXHYdluv3MV/un8s5X57F9rp8nfOr9s1t2/te9zrrtufbdbF917rtuuV+u/bftW5Xj4PX5X/qP7hQAQECBLoEBFOXrL4ECJQFBFOZTiEBAl0CgqlLVl8CBMoCgqlMp5AAgS4BwdQlqy8BAmUBwVSmU0iAQJeAYOqS1ZcAgbKAYCrT3Vhh2//UdmPfkQMT2BKI//M7/zREzrd28XJlAvHL1nHd4tcBTFcLpFHc2+7vq63WsDWuV/wtp6dxg7++OaNZv56yaWfWJPDapm/8Iq/paoH8ywtpdvXetq5F4PUIo39szubzMffRbi2X5vLziL8Q+PUxPtzskk8Fl1fcvi1p8q/xrcd9/cEYca/7GDwQVjzlE9On/weba0V5U6WJqgAAAABJRU5ErkJggg==',
			],
			'69700f79d1fb472ebd9ba3a3b9a9eda0' => [
				'name' => 'Pone Biometrics OFFPAD Authenticator',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'8da0e4dc164b454e972e88f362b23d59' => [
				'name' => 'CardOS FIDO2 Token',
				'icon_light' => 'data:image/png;base64,/9j/4AAQSkZJRgABAQEAYABgAAD/4QAiRXhpZgAATU0AKgAAAAgAAQESAAMAAAABAAEAAAAAAAD/2wBDAAIBAQIBAQICAgICAgICAwUDAwMDAwYEBAMFBwYHBwcGBwcICQsJCAgKCAcHCg0KCgsMDAwMBwkODw0MDgsMDAz/2wBDAQICAgMDAwYDAwYMCAcIDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAz/wAARCAAyADIDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD9/KKK+V/2pdDuPjb+2P4G+GuoaxrOm+FbzRZ9VuoNNuTbtdTAzBd55BA8lMZBxlsYLZrgzHHPC0lOMeZtqKV7Xcmkrvotdd/Q9jJMqWPxDpTnyRjGU5Ste0YRcnZaXelkrrXdo+qKK/OvXNP/AGb/AA/r1/ptxqvxZa4026ltJvLkLKJI3KNg7emQfwqr5/7NOf8AkKfF3/vo/wDxNfOPiuzs1T/8G/8A2h9xHw65kpR+sWev+7Pr/wBxT9HqK/ODwpc/Dtf2g/hgPhfe+Pri8bxJbDURqjPt+z71zjAHGN27PG3OeK/R+vYyfN/r8ZvlS5WldS5k7pPR2Xez0Pl+J+G3lEqScpP2kW7ThySVpOOseaW9rp31QUUUV7R8uFfLH7UmsXXwV/bG8DfEu+0XWtT8K2eiz6XdzaZbG4e1lJm27xwFB85cEkZw2MkYP1PXz/8AtKfHHx1a/HHwv8M/h7/YdjrmvWEup3GpasjyQwRJ5mFVVz8x8p8kq3VRgZLL4ufKH1ZOTaalFxsrvm5lyq2l7vTdeqPqOD3V+vuMIqUXCop80uVKDg+d8yTastU7PW2j2PO/gr+2L8K/gPp/iC20fTPidcR+ItauNduTeaXG7RzzKiuqbWXCARrgHJ68nt2n/DzvwF/0BPHn/goH/wAcqjoem/tF+J47ltN+JHwq1BbOdrWdrWEzCCZcbo32wna4yMqeRkcc1of8IH+09/0PHw5/8An/APjFeDh8RmNOmoUVLlW1qUbf+nT6/F4LJK9Z1cQ4Ob3bxEr/AD/2c0vA3/BRLwL478b6T4fgsfFlle65ci0tXvdN8qJpD0BO8nk4GQDjPOBkj3yvl1v2afjJ8QPi34H1zx34q8G6hp/g7U/7QSOwgkjmb7pZQPKUHOxRyRjk89D9RV72TVsZUjP62tn7rcVFtWV9FKXW63PkOJsLldCdJZZJO8W5pSc0pczStJwhe8bN6aNhRRRXtHy4V8v/ABb1uz8N/wDBTH4e3mo3VvYWj+Fp4lnuJBFGXzd/LubAzyOPceor6gri/i58A/B/x40u3s/F2g2etRWbs9u0heOWAtgNskRldQ21cgEA7VznArzc1wlTEUoqlbmjKMle9nytOzte1+9n6Hu8PZlQweJlLEp8k4Tg+WzaU4uN0m0m1e9m1fuj5r8G/C/4k/CLUvE0fg/4q/C3TdK8Q67d62YbiVZpA8xAGSyHGESMYBxkH1rc+2/HT/osvwj/AO+Y/wD41Xcf8O2vgof+ZJX/AMGt9/8AHqX/AIds/BX/AKEmP/waX3/x6vnaeS4+nHlppJdlWqJf+kH29bijJqsvaVpOUtLt4Sg27K2rdbU8vufjV8XPhl8Wvh/p+uePPAvinTPFWuQ6ZcQaTbxs8aO6KxZgqleG4IPUdxkV9h1474O/YL+E/wAP/FVhrWk+EYbXU9LmW5tZWv7uXy5FOVba8pUkHBGQcEA9QK9ir2snwmKoKf1mV7tWXNKdlZX1kk9XrsfKcUZll2LlSeXwtyxak/Zwp8z5m17sJSWisr3uwooor2j5YKKKKACiiigAooooAKKKKAP/2Q==',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'89b19028256b40258872255358d950e4' => [
				'name' => 'Sentry Enterprises CTAP2 Authenticator',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'4e768f2c5fab48b3b300220eb487752b' => [
				'name' => 'Hideez Key 4 FIDO2 SDK',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'47ab2fb466ac41849ae186be814012d5' => [
				'name' => 'Security Key NFC by Yubico - Enterprise Edition',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'931327ddc89b406ca81eed7058ef36c6' => [
				'name' => 'Swissbit iShield Key FIDO2',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'f8d5c4e9e5394c068662ec2a4155a555' => [
				'name' => 'StarSign Key Fob',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'b7d3f68e88a6471e9ecf2df26d041ede' => [
				'name' => 'Security Key NFC by Yubico',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'8d1b1fcb3c7649a991295515b346aa02' => [
				'name' => 'IDEMIA ID-ONE Card',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'30b5035ed2974ff7020baddc96ba6a98' => [
				'name' => 'OneSpan DIGIPASS FX7',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'454e534649444ffd6c938e9267193e9a' => [
				'name' => 'Ensurity ThinC',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'e1a9618350164f24b55be3ae23614cc6' => [
				'name' => 'ATKey.Pro CTAP2.0',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJYAAAA9CAIAAADAuAeYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAAEnQAABJ0Ad5mH3gAABGuSURBVHhe7ZwJfBPV9sczS/Y03Rco3XcKBVwRBHkiT58LqxvCE3AtoIICBQTZ2gItUigtVGihKPoXAR+yyPLhARZZ1EdVoPoQpKW0BVq6Zc9klvxPMrfQliZNl7QPP/l+LnTmnDuTyfzuvefcm0kws9kscHEvg6O/Lu5ZUC/8z4BnNL8WYYSIt3Y7HGsIeH5M/M4stO/CNkjCswPHan/5HRf/r0jI6gz+45/t/fkatO/CNmggxXhwHLbMNGM20d1TaEaAWy4DwzG4Ev7aXNgH9cLCR8ZBL8TEIjPHyWLCcYLo+jQHpDPTtO7iFUxIcnqD38vP9t6WgXwubNNUQpFQQDODq88Schnv7mKoylunAu4nlZ4uCR2neUYKirJaPdrpcjidAW25cJgWJxVdPYQ2ohtf+l7FNS+85+lMCVmDkTOZOBPF0TSHbC6cTqdJqP/vle9k0af8Hjrp++BJZT+mph45XDiZTpPwYuICAhebWVbAmVmjoWSxa1beRXSOhPristoTx3GFDCMIjMAJhdv1TdtpjRa5XTiTzpHw8rSFBOmBYRirN3IUIyAwAU2XLs5EbhfOpBMkNJTdqD58hJBKYELpN/455cN9zRRNKOTlG75g9K55ntPpBAkvTV9MkAoBJmBYTVTWorDUObSxDoZTjjJeS3Z91OB0OiQhzMMN16uq9x3CZVJOb/AZMUKodPMYfL8iKp6jaFIuL1+/jaNMqLYL59AhCTGB4MrMFIIQwzbNqGJyV/D2yDULGGM9dETIaErTN/JGF06iQxJSlbeqdu63dEGD0XvIMGlIIG/3eeZvssgYmOALZfKyNfkczfB2F86gQxJeSUrDcEIAiSitjtmYiqxWIlfOZQxqgZBg62rL1my22lzrn06h/RJS1bVVn+8l5FLOSHkMHCSPi0QOK77jnpKFRppNDC5TlGVsZs2cddx10fm0X8KShRlmM2vpgib17SjYmLC0JMagwUjCVHmrYt1nyOqis2mnhHS96mb+LkIuMzOMcsADsqhQqqoaQuPtYrpV6/X4I9KgYAHLEVJZ+apc1zDqJNopYcmSdWYTDTknRpLG4rKTnv1/CB7yQ8jQ2+VM0OAzIY8yKq2AwHEhaaiouL7pS3Swi06lPRIyWv3N3O3WhzMsz0yZIc6RJCYSNi8EASkMVIBapFR+bcUn6HgXnUrzZ2egbz1SekLk78u7W+TSe0uvZX1Ckm5oH4HhMgnIBVsgKmegmqWgNFPXOyczMPEVtN8ShuLSMxFD7n52JjdvS0HBCYlYrKeopYsWRkU1SZ2akZyS+uefxUJSCNdSr6p/8IEH5ibNrqmpfStxuqe7u9FkHDjw4XemTd29Z++Or3bI5Qo7mbKJNvVLSJg1a2ZxcfGsOfO8Pb04M0eQRO7GHFTDNnq94d0ZM+FO4BheW1+/MSfb19feXW03JPrrMGaW5erUPV56wdrJGoC+JiKrvtwvEAlBQFws9h33pOWJwkZ3hzPRhj+uoJ02cuHChf3fHpDL5VqdbuZ77yBrSyTNnb8pb7NcJocrUqnU8fFxu3ZsBztFGffs3Rvg76/T6iRiCVj+vHxl7/4Dnh4eZtsaGg1GygRtURAeHn6hqEij1pAkWa9SjRk9+ul/PMnXscXWrZ/u3Pm1m9LNaKDuG9DfSfoBbZYQlIvdthrtNOVG/g5S5G5mWDLQIy5/FbJ2BiKxWCqXQWEFHMRWZL2LufPm5+bn+/j6gn5wo/sPSPj+u2O8C7qCVGo5A2c2w9nAIhTC6G6x2JEQw3GRxKI3kJaaMuXtRH8Pd5wkl6eltSohtCRPH2+RUKjRaFNSliCrE2hbLKQp09Xl60tXbLianFX+yd3pScO9YFm0YQWspatyr6Zml8KxGVts3rCOMW/+wo15+d5e3tb+p4qLir6tX4vo9LqayltVllJtp6jrVXz9cc+PVcjkLMeKxaLffv+9sLCQt7fI9q92lJVXCIVCiqL6D+j38EMPIYcTaJuEFRn5lxYsvvLhqouL5pEyS1t2BAiPdFXNHws/urJg1aVZc27tOYIcnceChR/lbMr18bHqp1ZHhoefKDiKfDaY9f7M2pqbZSWXym2XqhulX2zbig6AV5k3R1WngpdQSGXJKSuRtSXWZa9XKOTwxuvqVR8mzUFW59AGCSEKlmfkSWQBhETqHv5gwKtjkcMBwlLel7gFEQo3kcjvqvWj4E7si/MXfJSVs9HX1wdurlqtjouOPn2yAPlsI5FIPD09le7udoqHh4dCoUAHCATTp0/DMYzjOJFEeurMqeLiEuRoysFDhy/+cVkoEtE0HR0R8dRTrQy5HaQNEpZnfWaqrhIICcaoDkttU8syE2Jx0MwprFaNSUTac+dqDp3orNW2JUuTczZu8rPGP7VaA8lqwfF/I1+LYB1qPW++8ZpGq8NxTCgUp6V/jKxNWbs2SyaXwfVAPJ71wQxkdRoOS8iZyz7OJaQKs4mRBocFvPwMsjuERa+g2a8TCqWA4wiRvLMejlqyNGVt9nofH0v/02g08bGxJ+3GPwtm69W0l6SkOSajEWZikBvtP3CgtrYGORo4feaHs7/+AvMfhmEC/QNeGf8ycjgNRyUsz/vSWFGOCUnaoA5b0p6WJVQqA6e+wmo1mESs+qmw9vgZ5Ggvy9PSIeT4eFviH6T70VFRR44cRD7bgH4dkdDDXTl2zCiY8+E4TjPsuqwNyNHA2rWZoB8/JCQmvoWszsQhCSG/LFu50dIFaUYaGNRjyvPI0UaCkt7GYSoNHVEo4yNiO8AJyzUvX5m+Kn21l7cXTEmh//WOiz125JCd+cZtYBTlB9Kqqqpfz50v+u13O+X8+aKSq80D3sL583RaLXRESFi2/d+XEPCQQyAoKvr9u+9PSqVSlmXdPZSvTZmMHM7EIQmrtn6tLymB4Z81aEI+nIasbUfs49VzygssxBKpuP770/WnLXl5myITZBNKN7fs9TnpqzO8fX1APxNFxcfFHT64HybdqJJj5OZtGTDggUFDhw0aYrPcP3DQjPdnowMaCI8If2zoECNF4QShUqnzNm9BDoEgMysLjPyo/uqECfIu+YKYQ822dHmOUCI3M4w4oGfPt+2tkLVK0PxEHCbLHIeT0pJFa5HVYWRSacrytOQVK72t46fAbGYoU+7GHJiBoRqt0jCMKuQKH39/fz8/+GerBPj7QVaKDmjEgg/nqVUqzCyQK2Sb8pCEpdeuHThwSC6TQcoqkYindckoCrQuYeX2/frLlwUiEavXBs15gx/H2ge0BklPf/+JY1itHpdJ6o6eUJ0tcjwyWTTD8CPHjrkpFNAdeQtGEnOS5vMVHKKh1xuNhrq6OlV9fX1dnZ2i17XwQPPDDz2Y0LcPRZuEpLC8vGL3N9+AEcYGmmUgRmp1urGjR/n5+fGVnU3ry9w/9n3K+Oc1DOKMTDqw7CRpXZ1qkWNYCKn0gHgp7uU/8JLNzNBQWvFj9HBcJOSMlOcTg/sdzEcO28vcs5PmffHl9sZTNJPJRJtoyN1Bxprq6pRlS6ZPTUS+lrh542ZUXN+AHv56rW7UqJEbsjNPnjp17Ph3MDtENVqCppnIiPCXXnwB7Tdiz779r05+3c/P12g0xsXE7Nvzr9j4BMtXzDFMr9OdPHEsIjwCVXUyrcSP6/m76otOkQIvRqCOmZ9sRz/ALGAt39NnoDRZYGuGNCTQ78Wnb37+L0Iqu3XosOb8RbeEWORzDK1W2yc+ftjQIZmZ2UovD08vr2Upy0cMHx4dHYVq2OZ26H108GAoaKftjHru2eBegRqdXiwWXy4uHj9xEs0wkMjAtT054gk7+jEMu/2rrwICAmBI0Wg1JpoOCw3pl9BPJHI4FjTF3qgI7xb6ZUxKWlT6gtjlK3rOfB05bCD08hX6+wgDfElfL2SyQcjiGeLAQKG/r8SvV1nGnXTAEeAeBQf12v/N1xCQ+t3Xz6DXwwAhEgqnvN5Fsec2774zXaW2rLcROFb488+gHwxpDM3MnPEuqtESJGn5HYORY55/dvSYc+fOUxQ1aswLUbG9YUhANdoKnA44O3Dsd+LYAre+8D91s4o3QljmNxyhWVXHj4RXuV1Zf+XqUUFQgTLhOBn128T3kdVsnjVnbkCvkMjY+KCwyEGPPgZvm7eXlpUFBoeFRcZExMZ7+/VY8NFi3n43N67fULj7wBl69AqdOv09ZO0Y0IFCw6PComIjY3tHxMTDyQNDwkeNGYfcdomK66P08r106RJsnzx1WqrwCI+MNRgsiwZtxV4vtKQPDtOsapuSFAcrw+VC/FuXmSESod/HCe7VKzV5aX29Cnwenp7Z2Rt++s9Z3tUFCEnytSmTNCoNbFuzYzNo8MFMx9c9MMpo+TAyNjbGTeEGg2p5RTnvqKyqgv9rqmsqypEFKDz787Lk1G2ffwF5ADJZaUnC2+Gi62n1pTEzhjW55kmv/nPE8L/pNFpoCR5enhP+OQk5bNGxNdJmvPfuOxKZGMYR2IY727dvn6FDh/Au+6BrsLZevV5nNBkJgoQZTlb2+lDo1PH9Pv1sG/xNGPAQTDGhDnTuF1+Z8NLLL3762RdePgGNW2oLElp+tqe7aO2l4Z3DyIt2Gsjfslkmk9E0DbNDlUrTSlDs2BppM9zd3UNDQlnWEgogSM98dzpytAZcA8jHT2cXLlisrq2bNHGCm5sbxNeQ4F6EULh9567nnntu0KCHwThn3od7v9m7Oj0tJipqS94nQrF45Og7HxM1l9AMN9Fu2ulUMMsI2eY7LJNJczZkq1QquI/u7sodu3btP2BzsdRy79BmJ3D06PFz5y+AEtCAIsMjRo8aiRwOIJfLZ8+bHx0bf/HS5d27v165Ej0Ob2mOFJW1ZvVn+Xn79uxmaPrbAweU3l49A3uCNzg42MfbS6XWnDmDFpmbTipgkCLIH8MfE9zV0rsCGOLg9d2U/DNUbeLvI4ZPGP/Sjl27QULI1ye/9sa1kssyaQvrW5Z+bN1Yty47dWU61LfutYyRMj4+bNjWLXlo/y5WpKd7KJVmgaULLl20EFkdQ6fVZa/JCAkNQfsNQEOE9w9hld/V6Q0URYMFJqC8BaYxkARTDRGxSS+0JBY4xplojmG7odCs5QF+jGhfN8lelxkY4A/JKg5zDLF47LhWPuVhOY6GGQDL2ingpps+RNKYwsKff/zprEgqgXo9/QNenTgROVri0OHDGzbc+ZIXNFNoSTp9C7/SxLfg20keNLIe8L5MpqtXr/IWPajLsv0T+vO7SEKYj1uUo0yW37Jj2O4rcBkmuAyOsVwGf20AwzCQLJggiwev7R+Hy9+SB00bWivkiscLCrLX33lUEJq2CQ62nMMEZ7NYODPrAHyq0iIr0lYplW5wp7V63eTJk+wsPUIfhSY1fXpiQcEJZNGooYlUVlbyu43R6XQmFhrXna+DLVu8iMDwzMxs2D59+oeSPy/PTZrt4enOe9EC24WxibqiyzCR562OA2/A5h1tzWsHzkD5jBwetQYNTanLV36zd59UKoHhZfOmjQkJfXj73axavWbnrq8lUgm8r5qa2u+PHfX2sawzVFZVPv7EP7y9vYwGw99HjEhJXrJly9bsnE8UbncW7e4G+vSgRx5Z83E62m9EcXHJfQ8O9PH1AY2hw5wvPCtXyJGvJd6b8UHRb7/t27tbr9O++ea0G7cqhYQQJ7DRI0d+8P6decjSZckHDh3GCcLT3X3a1MRnn3mat//yy6/LV6ykGAYXYONffrHxmp9FQhCxodf+1YD7C+Mq2ulU3nhr6rcHDyoUCrVa/cZrk1OTlyFHl2OV0Npd2of9Yzty5v9lbt2qjo1PgGkoDNAmiir86UyXfS5xN5YW2pG7bP/Yv6R+wKqMNaSQxDEM8hEY67pRPwDFQheOYzAawyOiZdZPviD1OH3ieHh4OO/qFpwSJ/7awIQSkkkIsaDlsKFDulc/wNUL20yv0AiRSAQSqupVRw7t699/AHJ0E65e2DbSV62uKC2rq62/XnGjT5/4btcPcPXCtnHu3HmaoaELMgwbFhrivK+cOY5Lwnse10B6jyMQ/D/exLg8R/4sQAAAAABJRU5ErkJggg==',
			],
			'9ff4cc6561544fffba099e2af7882ad2' => [
				'name' => 'Security Key NFC by Yubico - Enterprise Edition (Enterprise Profile)',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'4599062e69264fe795669e8fb1aedaa0' => [
				'name' => 'YubiKey 5 Series (Enterprise Profile)',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'9d3df6ba282f11eda2610242ac120002' => [
				'name' => 'Arculus FIDO2/U2F Key Card',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'fbefdf68fe860106213e4d5fa24cbe2e' => [
				'name' => 'Excelsecu eSecu FIDO2 NFC Security Key',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'62e54e98c2094df3b692de71bb6a8528' => [
				'name' => 'YubiKey 5 FIPS Series with NFC Preview',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'ab32f0c62239afbbc470d2ef4e254db7' => [
				'name' => 'TOKEN2 FIDO2 Security Key',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'ce6bf97f9f694ba7903297adc6ca5cf1' => [
				'name' => 'YubiKey 5 FIPS Series with NFC (RC Preview)',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'ad08c78a4e4149b986a2ac15b06899e2' => [
				'name' => 'YubiKey Bio Series - FIDO Edition (Enterprise Profile)',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'930b0c03ef464ac4935c538dccd1fcdb' => [
				'name' => 'Chipwon Clife Key',
				'icon_light' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAATAAAACwCAIAAAAHXqXIAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAABDuSURBVHhe7Z37bx3lEYYT32MntpNgTG44cezcnNhJbMcXHIJEgaoqRdAiVRUCStUWkHoBUVVVIYCUqqGkv/SHllZItFKLoP+k+3G+19vNa5/jvczszp4zjx6hJGd33tndGU7iOPaBbcdxzOAL6TiG8IV0HEP4QjqOIXwhHccQvpCOYwhfSMcxhC+k4xjCF9JxDOEL6TiG8IV0HEP4QjqOIXwhHccQvpCOYwhfSMcxhC+k4xiiRxfy2vzRH31n9t3XFj56+/p7ry98e+sUXnCcWunmhZw5MfbfPz9V0g/eXEI5x9Gn2xYyvN3RRsm6tjiFJMdRoEsWktamGpHtOHI0eyFpQ+ry6twkGnKccjRyISePDNFKGBH9OU5RGraQLz93lnbAoOjVcfLTmIV8dvMkzb1x0bfj5KEZC0mz3iBxAY6TDesLSfPdRL/69A4uxnH2w+5CDg320WQ3WlyV43TE6ELSNHeH/lbp7IvFhaQ57jJxkY6zF7YW8q/vr9P4dqW4WsfZhaGFpKntbn/1yhVctuOksLKQNK+94P1fL+PiHWcHEwtJk9pT4hY4Tov6F5IGNKM4OSd/+2CD6lgQzTlO7QtJo9nBR4+N4Bw5KKJG0ZDT89S5kDSUe4pDH2Zx4cqTmxvFRImHodBaRCuVsHTx2MvPnX39hbkH761SG52dOTGGEj0GTdGNxWt4QZraFpKeNImDUtzeWKebUl6UTkFtVCyaEIUipHzthTkEdC/Hjx2lgdlTHC1EPQtJTzctjthhfWWZrl9DhO1ALVXmb38i///d6eOHKEXQc6cOI6a7mBgfpwnZV5xZmhoWkh5qIl7egS64GpHdgtqrRmSLQhHiIqZboJHIJUqUoOqFpGcZxWs70EVWL/poQa1WIILlWFucoghxkdR8aBIKiEJFqXQh6SlG8VoLurZ6RU8tqGdtkSoH1dcQSU2GBqCwKFeIOhcSv9qCLsmIly/Mo7/t7fd/vkT9q4pUIf71hy2qryHCmgk9+pKiaH6qW8h2D29t+SZdjKAzZ84gpj0bt1bpLBLHtaCrUBWRQlBxJRHWNOiJi4jSOaloIds9NroGKVG9KFQtiBda0LXoiTwhqLieyGsO9KylRPWcVLGQE4cH93xgdAHlRV1RkuLrqyv4Jd/JjiKsOSSPWFwE5KGKhdz9tMp8qs1uN2+txrKqxCz8pJk7SZX1RF4TSKZIQ2TkQX0hdz8narqMW+trsWZlhFD8qJlvOFRcyf6+g8gzT3qcNERMZqpbyPhTareMsWD1rFy/jh81cCepsp7IMw8NlbiIyYzuQtLjoV4LG6tZ4NT0aHKNej67eRJ5ElBxJRFmm3Mzj9NoiYukzCgu5PNPnUk/G2q0sLGaHZIRVBVhElBlPZFnGBotDZGUGcWFTD+Vq5cvUaMFnJs9F6tZIxlBVREmAVVWEmGGoQHTEEmZ0VrIf3y4mX4q1GUBYx2b/PQHF5Ip1BNhElBlPZFnFZoxDcfGRhGWDa2FTD8ParGAsY5lkhFUFWESUGUlEWYVGjMNh4eHEZYNlYX87O43X7om/pj6K2CsY5/0ICqJJAmosp7IMwlNmoZIyozKQobH8MfW1zik5goYCzaC9BTqiTAJqLKSCDMJDZuGSMqM/ELGT5SLP6bm8hqLNIj0ICqJJAmosp7Is0f4Ax6NnLhIyoz8QiYPgDrLa39/f6zTIAb6D6YHUcPp44cQJgEVVxJhJqGpExcxmdFaSGqrgLFa40gPopJIkoAq64k8e9DUiYuYzAgvZHLrqa28xiINJT2IGg4PSf7egYoriTB7qH6yDjLyoLKQ1FZeY6nmkh5EJZEkAVXWE3n2oPETFAF5kFzIgwdRjdrK5eDgYCzSaGgWxV29+giSJKDiSiLMJDSEIqJ0TiQXMt50aiuvsVTTeWbjZHoWNUSSBFRZT+TZg4awvFOPHEfpnAj/ljVAneUSJboCmkVxT0z5h1sloVEsKYrmR3ghqa28okq3QOMoLmIkoMp6Is8kNI2FRblCGFpIlOgiaBbF9Q+3ikMzWUAUKorkQvb19VFzuUSV7oLGUVzESECV9USeVWgsszs5MY4SJZBcSOovlyjRddAsiosYIai4kgizDc3nvuK00vhCqkPjKC5iJKDKeiLPPDSlu91cu4VDhfCFVIdmUVzECEHFlURYo3j89On11ZUbi9dEfmvaDrGFpAXLJUp0LzSO4iJGAqqsJ/Kch/GFrAKaRXERIwQVVxJhzsP4QlYEjaO4iJGAKuuJPCeFL2RF0CyKixghqLiSCHNSyCzk0tUF2rHsHp2cRJVuh8ZRXMRIQJX1RJ6zg8xC0o7lEiV6AJpFcREjBBVXEmHODr6QlULjKC5iJKDKeiLPaeELWSk0i+IiRggqriTCnBa+kFVD4yguYiSgykp+/eAO8hxfyOqhcRQXMRLc+8UNKq4k8hxfyFqgcRQXMRJQZSU///gJ5PU8vpA18MW9LZpIWREjwXfvnKbiSiKv5/GFrAcaR3ERIwFVVnJ+RvEzthuEL2Q9fPXpHZpIWREjwds/vETFlUReb+MLWRs0juIiRgKqrOToyADyehhfyNqgcRQXMRJ88u4yFVcSeT2ML2Sd0DiKixgJqLKSCJODhk3Q6akpZIjiC1knNI7iIkYC7Y8MJyKvNDRm4iJGmvoX8sqli6jSk9A4iosYCaiykggrwdzsOZoxDREmTf0LGUSVnoTGUVzESKD9keFE5BViYGCApktDhCkgs5AB6jiXKNGr0DiKi5jShCdFlZVEXiHSc6UnwhTwhawfGkdxEVOO82fPhidFlfVEak7SQ6UnwnTwhTQBjaO4iClB8rCospJIzcP66krSpKrI08HEQgZRpVehcRQXMUVJPymqrCeyM5NuUk+EqSG2kMtLi9R6LlGlV+nvP0jjKOuXnzyJpELQw6LiSiI7G9ShnshTQ2whA9R6LlGih6FxFBcx+aEnFaTKeqKD/dhaX6MOlezv60OkGlYW8gnp75HQOL7/rRkaR1n//mGR/+vRY0qk4kqiif2g3vREniZWFjKIKj0MjaO4iMkDPaNEqqwn+mgPNabnzaVFRGoiuZABuoZcokQPE/6kR+Mo6923lpCUDXpAJBVXEq20If5lTDUiUhmxhbz/znL4L11DXmOpXobGUVzEZIOeDkmV9UQ3e0EtqYpIZYTfIUt+GiGq9DA0i+K+8dI8kvaDHs2eUnEl0dAuqBlVEamP5EKGe3fgwAG6kryiVg+TnkUNEdMReijtpMp6oq2HoWZURaQ+8gt5e2OdLiaXqNXDpAdRwywfbqWH0kEqriTaSkFtqIrIShBeyM8/3vQ3yfKkZ1FDxLSBHkdnqbKeaK7F+soytaEqUitB+M+Q4caFhSz/F7Uo16ukB1HDu2+2/XDrzJnT9Cz2lYorif5aUAOqjo2OIrUS5Bcy6G+S5UkGUUnE7IIeRBapsp5osXt/vxrQWsiR4WG6sLyiYq+STKGSb7y4x4db6RFkl4oriS5bUANKblb+CWTCCxmI9678m2QQFXuVZBCVREwKuv/Zpcp6otGqFhJhFaK1kIMDfb6TJUmmUMlnNk4iqQXd+bxScSXRawtqQEMkVYj8QgbivQsLOT87S1eY10enHkHR3uP28nQyiEoiKWSV+8uqIFXWEx3rLyRiqkVxIYM99Sb56vfOJxcevbPyGF4rChUU9/LsRAyie15MKq5kbDhCDciKjGpRWchAvHc3Lx/vkZ1MxmVPcVB+qI6GSJIYbqqsJzrWXEgEVI7uQgbDQors5JHDh1HaHjMnDyfX20EcnRMqIu7kkaEYRDe8mFRcydhw4NDICDUgJQIqR2shA8ntk9rJIEobI7nSLOKczNDpGiLJ3yR3ROk6qGIhg2EhT554jC67mKhuhvRlZhcnZ4POFbe//2AMoltdTCquZGw4cOXiRWqgvChdB4oLGUjfQak3yeDwEH6XVTvpC8wrSmSATtQQSf4mublxYe486taB7kIGktv3z3tbgjsZREDlJJ/cmFxaYWOdLNCJ4iJGYrg3b61ScSXRsfRComhNVLeQwfjZArJf0BYxVZEkpq+rjLHavtBZGiKpOW+SX9zbQseiO4mKNaG+kIH0TRwa/GYn+/v76S6UFElqjI6OpoPSV1TeWLMzC+cn6SxxkSQx3OvL16m4kuhYbiFRrj6qWMhA+iZev3Qs/iLdi/IODQ7GylKMjWEPo/EX09ciZazcGTpFQyQ1500S7bagBoqJWvVR0UIG0vfxyz/hC2nT7ZByocT3nLw4P0fVgrc31uOr6auQNdbvAB2vIZIknsvttatUXEl0LNEzCtVKdQs5MtyvdyuzOD87Oz01NTE+fvzY0SsXL9CrHUSX+iuBmPbQ8RoiSeKhUGUlR0cG0HHpnlGlVqpbyADdyiBeqGon83pj8Vps78F7K9S5kjGuHXSwhkiSeCJHxgapuJLouFzPKFE3lS5kgG5lFK8ZW0v0VMkaJN775U2ktoGO1xBJ5R5H/N4QVFnJ2G2E2sguzq+bqhcyQHczitda0J2qXvRR7SpG1xenkN0GOl5DJEm84czPjFNxJWNcgNrIKE42QA0LGaC7mYiXW9Atq8DHph9F9vb20+snqLcKzPIFGsPG0lkaIkziDYcqK4mwFtRJFnGmAepZyADd0LQ4okVfXx/dO3Gnpx56U7r71hL1U5noYD/oLA2RJPGG88zGSSquJPLy9zx/fhZnGqC2hQzQDSVxUAq6j2VcXLiCoimogSr9T55vqErnKokwiTccqqwkwlpQP53FOTaocyEDrzzP/8qefOfVPTYncGl+nm5rBy9f6PQNLSixej96+zpayQxV0BBJ+RcSp6V446V5Kq4k8nwhS0K3tZ04ujRjhwaoco2OHy7y2UVUREmEScw3VVYSYdvbo4cOUVftxAlmMLGQAbqzWRwe6sfJ7Tk1PfqX363RiXZEl4WgUhoiKc9CToyP45yH+f3PFqm4ksjL3DOONoOVhQzQne16cdlFoWpKIkxivqmykgjb3l64fIl62y0OtYShhYzQ/e1WcbXloJoaIinbQq6tfPNNeztAxZVEWIaecZwlzC1kgO5vl3n75jSuszRUWUmEScw3VVYSYfs1jIOMYXEhI3SXu0NcmxxUX0MkCb3hUHElEdaxZxxhDLsLGfjq0zt0o5vrEzf+/2lAslCQhkgSmm8qriGS2jc8MX4ERxjD9EJG6F43UVyJDpSlIZKas5BBhLXpGa/ZowELGaHb3RTRvTIUqiGShOabimuIpL0a3lpfw2v2aMxCRuimWxYdVwWli4sYuTccqq8hknb1jF81ScMWMkL33ZrosnKoDXERIzffVF9cxPhCVsPxyWF6APX69YM76KwmJg7r/gt9xIjON0WIi5hUz/i5VRq8kGnoMVQsmrAB9SYrMqTnm1IERYAvZF3Q89Dz/jv7fFZKjVCrgiJge/v82bOy801BgiKgtZP4kWG6bSHT0IMp77/v5/hXi/Wi9xUPENCa776+PvxECMoSEaV9IQ3y2d0cX5vwNz++itMay9TREbqo8qL09jZ9pQVBBgf6KLSkqNsEemshe5wXn36cJnVfX39hrti/2HSK4QvpOIbwhXQcQ/hCOo4hfCEdxxC+kI5jCF9IxzGEL6TjGMIX0nEM4QvpOIbwhXQcQ/hCOo4hfCEdxxC+kI5jCF9IxzGEL6TjGMIX0nEM4QvpOIbwhXQcQ/hCOo4hfCEdxxC+kI5jCF9IxzGEL6TjGMIX0nEM4QvpOIbwhXQcQ/hCOo4hfCEdxxC+kI5jCF9IxzGEL6TjmGF7+3+qYMJZpgx5tgAAAABJRU5ErkJggg==',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'7787a48213e847848a06c7ed49a7aaf4' => [
				'name' => 'Swissbit iShield Key 2',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'72c6b72d85124c6683599d3d10d9222f' => [
				'name' => 'Security Key NFC by Yubico - Enterprise Edition (Enterprise Profile)',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'99ed6c2945734847816d78ad8f1c75ef' => [
				'name' => 'VeroCard FIDO2 Authenticator',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'973446cae21c9a9b99f59b985a67af0f' => [
				'name' => 'ACS FIDO Authenticator Card',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'74820b05a6c940f98fb09f86aca93998' => [
				'name' => 'SafeNet eToken Fusion',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'1105e4edaf1d02ffffffffffffffffff' => [
				'name' => 'Egomet FIDO2 Authenticator for Android',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'08987058cadc4b81b6e130de50dcbe96' => [
				'name' => 'Windows Hello',
				'icon_dark' => 'data:image/svg+xml;base64,PHN2ZyBpZD0iTGF5ZXJfMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2aWV3Qm94PSIwIDAgMjU2IDI1NiI+PGRlZnM+PHN0eWxlPi5jbHMtMXtmaWxsOiMwMDc4ZDQ7c3Ryb2tlLXdpZHRoOjBweDt9PC9zdHlsZT48L2RlZnM+PHJlY3QgY2xhc3M9ImNscy0xIiB4PSIyNC4yNSIgeT0iMjQuMjUiIHdpZHRoPSI5OC4zNSIgaGVpZ2h0PSI5OC4zNSIvPjxyZWN0IGNsYXNzPSJjbHMtMSIgeD0iMTMzLjQiIHk9IjI0LjI1IiB3aWR0aD0iOTguMzUiIGhlaWdodD0iOTguMzUiLz48cmVjdCBjbGFzcz0iY2xzLTEiIHg9IjI0LjI1IiB5PSIxMzMuNCIgd2lkdGg9Ijk4LjM1IiBoZWlnaHQ9Ijk4LjM1Ii8+PHJlY3QgY2xhc3M9ImNscy0xIiB4PSIxMzMuNCIgeT0iMTMzLjQiIHdpZHRoPSI5OC4zNSIgaGVpZ2h0PSI5OC4zNSIvPjwvc3ZnPg==',
				'icon_light' => 'data:image/svg+xml;base64,PHN2ZyBpZD0iTGF5ZXJfMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2aWV3Qm94PSIwIDAgMjU2IDI1NiI+PGRlZnM+PHN0eWxlPi5jbHMtMXtmaWxsOiMwMDc4ZDQ7c3Ryb2tlLXdpZHRoOjBweDt9PC9zdHlsZT48L2RlZnM+PHJlY3QgY2xhc3M9ImNscy0xIiB4PSIyNC4yNSIgeT0iMjQuMjUiIHdpZHRoPSI5OC4zNSIgaGVpZ2h0PSI5OC4zNSIvPjxyZWN0IGNsYXNzPSJjbHMtMSIgeD0iMTMzLjQiIHk9IjI0LjI1IiB3aWR0aD0iOTguMzUiIGhlaWdodD0iOTguMzUiLz48cmVjdCBjbGFzcz0iY2xzLTEiIHg9IjI0LjI1IiB5PSIxMzMuNCIgd2lkdGg9Ijk4LjM1IiBoZWlnaHQ9Ijk4LjM1Ii8+PHJlY3QgY2xhc3M9ImNscy0xIiB4PSIxMzMuNCIgeT0iMTMzLjQiIHdpZHRoPSI5OC4zNSIgaGVpZ2h0PSI5OC4zNSIvPjwvc3ZnPg==',
			],
			'a4e9fc6d4cbe4758b8ba37598bb5bbaa' => [
				'name' => 'Security Key NFC by Yubico',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'0acf3011bc60f375fb536f05f43154e0' => [
				'name' => 'Nymi FIDO2 Authenticator',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'd91c52880ef049b7b8ae21ca0aa6b3f3' => [
				'name' => 'KEY-ID FIDO2 Authenticator',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'8eec9bf9486c46da9a671fbb4f66b9ed' => [
				'name' => 'HID Crescendo 4000 FIPS',
				'icon_light' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAVMAAACsCAYAAADG+E8MAAAAIGNIUk0AAHolAACAgwAA+f8AAIDpAAB1MAAA6mAAADqYAAAXb5JfxUYAAAAJcEhZcwAAD2AAAA9gAXp4RY0AAAygSURBVHhe7Z1/bJTlHcBvjhjNcC4O+dXeXVtUTMziP7oYXZY51IkKd1fNnFHj5ohBmA7j2MRsZolmxhhNJort24KgsiFsim7TAdMYRFQEFTcVxw/rwAEFRChQ+uuePc/1qQP3TNs+33veu+vnk3zS42gfnve9t58+773XIwEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAUEpkG6/XPpnIRR8gIh5t41r9cYatBfwP9Q3n6x20TZtP1DcpRMTPNdeU14uuVt2Mq21FBkxtMjmrLpVq0R8311ZX32rvLmMKP230jqmP3DsNEfHzzEW7ExfOGWmL8oWkk8kf1qXSPXXVqaXJUaPOqKmqOrMumfprbTLVnUqlLrefVkZMmP11/ZOlw7lzEBEHojmrzUZTbV3+L3Vjx04wIR09evTJ41KpKdobjCNHjhw1duzY5Lh0jdKr1LPtp5cBJqSsRhFR0t6gzrSVcXGMDqmqSSYz+vYwE86aqtS1tdXp683tujFjUjVjk5P1KrW999PLgVzU5dwZiIg+mqBeOqfOluYo0un0cTqmXfaPw8wK1d5O6FP8t2rT6Vv0zS+bsPbeW+rkoo+cOwERUcJcdMDW5iiqq6uPH5eq6Vt1FlamOqI761I1209J1/RF9kvlEdP6hm87Nx4RUdJswz22Op9iYqpXo532j2Zlmj/ppJO+qj92p8eMOd3ef0x5xDTXtM+54YiIkuaiDludI+k9hU8njtO3CzE1d44YMWKMvn3Q3B4+evjJ+nbfKrWE4XWkiBjKy5vPsuX5lLpUamZtMr3f3K6tTr5TuFNTl0w+WpNK3az/rqO2Oj3N3l2iTI6mOjcYEbEY5pqetfU5irrq1DO1ydSBcVWpG+xdibqq5AyzOtX3L7R3lTD10XLnBiMiFsNcU+HU3UVyVPIMHdWVp9XWqVNravP69vKqEVWn2r8uceqj/c4NRkQshrmojF4vOhCIKSKG1H0RqgIgpogYUmKKiCggMUVEFJCYIiIKSEwREQUkpoiIAhJTREQBiSkiooDEFBFRQGKKiCggMUVEFJCYIiIKSEwREQUkpoiIAhJTQS97WCUueEAlLpwdVvNv5iL3nAbr9x50/1vF9iKtaz4DMa7HwDz+rvn0x6x+/OKYdzE023GRPn7MMXSp3ieTG93bXGkSUzlvnvuyiovjrpznnNOg1Af/us277Mhh2fnJod5vQNe8+qP+Jo6LadEq95z64deuXWBHqQw6u3tUW3un2rxjn1q9Yadasnqzuqn5ZXXyNQtU4uKHVCJTgYElpnKab6a4qJSYfrTnQNnG9IaHX3LPqR+eqCMzVNiz/7Ba8dZWdeV9z6vEBL2KrZSwElM5iak/xHRo0dnVo55d96Eaf+Miv6dJSkFiKicx9YeYDl3ebtmjzpu11O/xj1NiKicx9YeYwhtbdqlTpuqVqrko59hXJSsxlZOY+kNMwzPrsTXqzsVvqLuWvKEydy9TuXuWq18ufL1w371L16sV67cVLiaFpCefV4+++E+VuGC2c3+VpMRUTmLqDzENT2LCb/UqsFElMg3/nZO5KFS4TztJPx6XzlFVUxaqKXNWqo/bDtuvLD6729rVN366xITqqP1VkhJTOYmpP8Q0PIXXhjrm5FRH7ZjJDeqO36+1X118unt61C2PrNbH5RGxL0WJqZzE1B9iGp4BxbRPHbZJdy+zI4Rh/gvvF1bIzvmUgsRUTmLqDzENz6Biasw0qh/r0/6QPPnqB37HRzElpnISU3+IaXgGHVNjNlJ//3CPHSkMT7/WUppBJaZyElN/iGl4vGKqHf+TxXakcPzxFb1CLbXnUImpnMTUH2IaHt+Ymqi9t22vHS0cP1vwqns+cUlM5SSm/hDT8HjHNBep825/2o4Wjnw+r8ZPX+yeUxwSUzmJqT/ENDzeMdV+5apH7Ghh2XewQ2T+IhJTOYmpP8Q0PCIxmmRO9T+xI4blmTUthdWxc14hJaZyElN/iGl4RGKajdQt816xI4Zn+FWCx/9gJaZyElN/iGl4pE6Tz5yxxI4Ynvc/2tv766+OeQWTmMpJTP0hpuGRiuno6x+3I8bDiOsedc4rmMRUTmLqDzENj1RMh13RbEeMB3PMxvrcKTGVk5j6Q0zDIxVTcxGqq7vbjhqeru4euW0ZjMRUTmLqDzENj1iA9HGzdlOrHTUebp0f4wv5iamcxNQfYhoesZhmGtXClRvtqPGwbbc+fuJ6h35iKicx9YeYhkcspjpitz22xo4aD+0dXSoxMaa36SOmchJTf4hpeCRjGudrTfuI7ao+MZUzzph+51d/UufOelrEb/78KbUhhjeuMBDT8IjFNKbf0f8stz2+xj2/YktM5YwzppUCMQ2PWEy159y21I4aH6ve3e6cW9ElpnISU3+IaXgqLaZb47oIRUzlJKb+ENPwVFpMt+892Pu/qjrmV1SJqZzE1B9iGp5Ki+mufe0qlnfhJ6ZyElN/iGl4Ki2mhfc4vczjGBqsxFROYuoPMQ1PxZ3mf8xpvizEtCwhpuGptJju2HuImIpCTMsSYhqeSovpBzv3m7A551dUiamcccbUvMHE60Ku2bhTHWjvsiOHhZiGp9JiumT1Zufcii4xlTPOmB5rfhKbJ90lvPgh9frGeN79h5iGRyymJfIbUPX3LHfPr9gSUznjjCm/m28lpgNGLKYl8rv5sZziG4mpnMTUH2IaHsmYTo/5usH+Q529Z1eu+RVbYionMfWHmIZHLKaZRrXopU121HhY37Kblak4xHTwEtNBQUwb1Yr12+yo8XD2zKXuuYWQmMpJTP0hpuERi+nkBtX6ySE7anja2vUp/iUxvTG0kZjKSUz9IabhkXzONE6eWLXJPa9QElM5iak/xDQ8UjE98Zr5dsTw9PTk43nbvSMlpnISU3+IaXikYnrq9CfsiOH5y7p/mZg55xVMYionMfWHmIZHJKY6ZJfc+ZwdMSyHO7v1MRPjc6V9ElM5iak/xDQ8IjHNNKolq7fYEcMyrXGVe06hJaZyElN/iGl4RGIa08WnTdv3xfci/c9KTOUkpv4Q0/BIxHT8tEV2tHC0d+jTe32suuYTi8RUTmLqDzENj3dM9Sn+3Oc32NHCYK7enzXzSfd84pKYyklM/SGm4fGN6fAfzLMjhWPGvJedc4lVYionMfWHmIbHK6aTG9Tcv4Vdld6+cI0Jl3s+cUpM5SSm/hDT8Aw6ptlInX/Hn+0oYbipeVU8/yVJfySmchJTf4hpeAYV00yDOvf2Z+wIxae7J69+NPvF0lyR9klM5SSm/hDT8PQ7piZk+rTeHGv3PrXefnXxOdjeqcZNXeSeUylJTOUkpv4Q0/AkvnV/77stfdaJD6lhVzSrE6+er06/abHK3L1c/SHwC/OXvbm1MA/XPis5iamcxNQfYgqGg4c71VX3P19YCbv2V0lKTOUkpv4Q06FNR1e3enjZuyrx3Qec+6mkJaZyElN/iOnQpL2zSzWt2NB7Sl/KF5k+T2IqJzH1h5gOHfL5vHq7ZY+aMmelSlygV6LlGtE+iamcxNQfYlrZfNx2WK16b4e60bzTU7ZRJSZ5PNalJjGVc9Jvlqnlb24tXIEM6cp3/q2O/f5c55wGZaZRPfjsP5z/VrH93cqN+hvM46LDxDnqpXe3O8cupive2qYuues595z64QlXz1e797erlta2ivDNLbvV2k2thX3z6yfWqol3PqdOMD/wL9an8fqHtWsflL3EFLEENKe45uVIZlVe7prtMFfhy+lKvITEFBFRQGKKiCggMUVEFJCYIiIKSEwREQUkpoiIAhJTREQBiSkiooDEFBFRQGKKiCggMUVEFJCYIiIKSEwREQUkpoiIAhJTREQBKzamuajVucGIiMXxoK1PhZFtaHJsLCJiccxFu2x9Kowrmsc7NxgRsRhmol/Y+lQg5jkM10YjIkqai/K2OhVKrukF54YjIkqai3bY6lQwuajbufGIiBLmtOfcd7wtTgWTi6Y7dwAiooS5aJmtzRCgPnrNuRMQEX3MRq22MkOIbONG585ARByMuaYKfSlUf8hFi/QOyOuVqnvnICJ+kebKfX3TWluVIUw2Ok2vUluJKiIO2Fy0N5Ftus7WBAqYqNZH6/THfTqsnYn6Zr2zEBGP0KxCs1GbbsSWRKZhgq0HAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEBpkUj8B4Aom+MbT+3JAAAAAElFTkSuQmCC',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'4c50ff1010574fc6b8ed43a529530c3c' => [
				'name' => 'ImproveID Authenticator',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'c611b55c77b245278082590e931b2f08' => [
				'name' => 'Idem Key (Consumer profile)',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'ee041bce25e54cdb8f86897fd6418464' => [
				'name' => 'Feitian ePass FIDO2-NFC Authenticator',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'4b89f401464e4745a520486ddfc5d80e' => [
				'name' => 'IIST FIDO2 Authenticator',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'2cd2f727f6ca44da8f485c2e5da000a2' => [
				'name' => 'Nitrokey 3 AM',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'10c707152a9a4de1b0aa3cff6d496d39' => [
				'name' => 'eToken Fusion NFC FIPS',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'efb96b10a9ee4b6ca4a9d32125ccd4a4' => [
				'name' => 'Safenet eToken FIDO',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'4b3f8944d4f24d21bb19764a986ec160' => [
				'name' => 'KeyXentic FIDO2 Secp256R1 FIDO2 CTAP2 Authenticator',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'4c0cf95d2f4043b5ba424c83a11c04ba' => [
				'name' => 'Feitian BioPass FIDO2 Pro Authenticator',
				'icon_light' => 'data:image/png;base64,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',
				'icon_dark' => 'data:image/png;base64,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',
			],
			'5343502d534353436172644649444f32' => [
				'name' => 'ESS Smart Card Inc. Authenticator',
				'icon_light' => 'data:image/png;base64,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